/*
 * Copyright (C) 2007 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

/**
 * Basic utility libraries and interfaces.
 *
 * <p>This package is a part of the open-source <a href="http://github.com/google/guava">Guava</a>
 * library.
 *
 * <h2>Contents</h2>
 *
 * <h3>String-related utilities</h3>
 *
 * <ul>
 * <li>{@link com.facebook.presto.jdbc.internal.guava.base.Ascii}
 * <li>{@link com.facebook.presto.jdbc.internal.guava.base.CaseFormat}
 * <li>{@link com.facebook.presto.jdbc.internal.guava.base.CharMatcher}
 * <li>{@link com.facebook.presto.jdbc.internal.guava.base.Charsets}
 * <li>{@link com.facebook.presto.jdbc.internal.guava.base.Joiner}
 * <li>{@link com.facebook.presto.jdbc.internal.guava.base.Splitter}
 * <li>{@link com.facebook.presto.jdbc.internal.guava.base.Strings}
 * </ul>
 *
 * <h3>Function types</h3>
 *
 * <ul>
 * <li>{@link com.facebook.presto.jdbc.internal.guava.base.Function}, {@link com.facebook.presto.jdbc.internal.guava.base.Functions}
 * <li>{@link com.facebook.presto.jdbc.internal.guava.base.Predicate}, {@link com.facebook.presto.jdbc.internal.guava.base.Predicates}
 * <li>{@link com.facebook.presto.jdbc.internal.guava.base.Equivalence}
 * <li>{@link com.facebook.presto.jdbc.internal.guava.base.Converter}
 * <li>{@link com.facebook.presto.jdbc.internal.guava.base.Supplier}, {@link com.facebook.presto.jdbc.internal.guava.base.Suppliers}
 * </ul>
 *
 * <h3>Other</h3>
 *
 * <ul>
 * <li>{@link com.facebook.presto.jdbc.internal.guava.base.Defaults}
 * <li>{@link com.facebook.presto.jdbc.internal.guava.base.Enums}
 * <li>{@link com.facebook.presto.jdbc.internal.guava.base.Objects}
 * <li>{@link com.facebook.presto.jdbc.internal.guava.base.Optional}
 * <li>{@link com.facebook.presto.jdbc.internal.guava.base.Preconditions}
 * <li>{@link com.facebook.presto.jdbc.internal.guava.base.Stopwatch}
 * <li>{@link com.facebook.presto.jdbc.internal.guava.base.Throwables}
 * </ul>
 *
 */
@CheckReturnValue
@ParametersAreNonnullByDefault
package com.facebook.presto.jdbc.internal.guava.base;

import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
