/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.BlockUtil;
import com.facebook.presto.jdbc.internal.spi.block.ShortArrayBlock;
import com.facebook.presto.jdbc.internal.spi.block.ShortArrayBlockEncoding;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ShortArrayBlockBuilder
implements BlockBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ShortArrayBlockBuilder.class).instanceSize();
    private BlockBuilderStatus blockBuilderStatus;
    private int positionCount;
    private boolean[] valueIsNull;
    private short[] values;
    private int retainedSizeInBytes;

    public ShortArrayBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this.blockBuilderStatus = Objects.requireNonNull(blockBuilderStatus, "blockBuilderStatus is null");
        this.values = new short[expectedEntries];
        this.valueIsNull = new boolean[expectedEntries];
        this.updateDataSize();
    }

    @Override
    public BlockBuilder writeShort(int value) {
        if (this.values.length <= this.positionCount) {
            this.growCapacity();
        }
        this.values[this.positionCount] = (short)value;
        ++this.positionCount;
        this.blockBuilderStatus.addBytes(3);
        return this;
    }

    @Override
    public BlockBuilder closeEntry() {
        return this;
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.values.length <= this.positionCount) {
            this.growCapacity();
        }
        this.valueIsNull[this.positionCount] = true;
        ++this.positionCount;
        this.blockBuilderStatus.addBytes(3);
        return this;
    }

    @Override
    public Block build() {
        return new ShortArrayBlock(this.positionCount, this.valueIsNull, this.values);
    }

    @Override
    public void reset(BlockBuilderStatus blockBuilderStatus) {
        this.blockBuilderStatus = Objects.requireNonNull(blockBuilderStatus, "blockBuilderStatus is null");
        int newSize = BlockUtil.calculateBlockResetSize(this.positionCount);
        this.valueIsNull = new boolean[newSize];
        this.values = new short[newSize];
        this.positionCount = 0;
        this.updateDataSize();
    }

    private void growCapacity() {
        int newSize = BlockUtil.calculateNewArraySize(this.values.length);
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.values = Arrays.copyOf(this.values, newSize);
        this.updateDataSize();
    }

    private void updateDataSize() {
        this.retainedSizeInBytes = BlockUtil.intSaturatedCast((long)INSTANCE_SIZE + SizeOf.sizeOf(this.valueIsNull) + SizeOf.sizeOf(this.values));
    }

    @Override
    public int getSizeInBytes() {
        return BlockUtil.intSaturatedCast(3L * (long)this.positionCount);
    }

    @Override
    public int getRegionSizeInBytes(int position, int length) {
        return BlockUtil.intSaturatedCast(3L * (long)length);
    }

    @Override
    public int getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public short getShort(int position, int offset) {
        this.checkReadablePosition(position);
        if (offset != 0) {
            throw new IllegalArgumentException("offset must be zero");
        }
        return this.values[position];
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.valueIsNull[position];
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        blockBuilder.writeShort(this.values[position]);
    }

    @Override
    public Block getSingleValueBlock(int position) {
        this.checkReadablePosition(position);
        return new ShortArrayBlock(1, new boolean[]{this.valueIsNull[position]}, new short[]{this.values[position]});
    }

    @Override
    public Block copyPositions(List<Integer> positions) {
        boolean[] newValueIsNull = new boolean[positions.size()];
        short[] newValues = new short[positions.size()];
        for (int i = 0; i < positions.size(); ++i) {
            int position = positions.get(i);
            this.checkReadablePosition(position);
            newValueIsNull[i] = this.valueIsNull[position];
            newValues[i] = this.values[position];
        }
        return new ShortArrayBlock(positions.size(), newValueIsNull, newValues);
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new ShortArrayBlock(positionOffset, length, this.valueIsNull, this.values);
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        boolean[] newValueIsNull = Arrays.copyOfRange(this.valueIsNull, positionOffset, positionOffset + length);
        short[] newValues = Arrays.copyOfRange(this.values, positionOffset, positionOffset + length);
        return new ShortArrayBlock(length, newValueIsNull, newValues);
    }

    @Override
    public BlockEncoding getEncoding() {
        return new ShortArrayBlockEncoding();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ShortArrayBlockBuilder{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }
}

