/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.resourceGroups;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ResourceGroupId {
    private final List<String> segments;

    public ResourceGroupId(String name) {
        this(Collections.singletonList(Objects.requireNonNull(name, "name is null")));
    }

    public ResourceGroupId(ResourceGroupId parent, String name) {
        this(ResourceGroupId.append(Objects.requireNonNull(parent, (String)"parent is null").segments, Objects.requireNonNull(name, "name is null")));
    }

    private static List<String> append(List<String> list, String element) {
        ArrayList<String> result = new ArrayList<String>(list);
        result.add(element);
        return result;
    }

    private ResourceGroupId(List<String> segments) {
        ResourceGroupId.checkArgument(!segments.isEmpty(), "Resource group id is empty", new Object[0]);
        for (String segment : segments) {
            ResourceGroupId.checkArgument(!segment.isEmpty(), "Empty segment in resource group id", new Object[0]);
        }
        this.segments = segments;
    }

    public String getLastSegment() {
        return this.segments.get(this.segments.size() - 1);
    }

    public List<String> getSegments() {
        return this.segments;
    }

    public ResourceGroupId getRoot() {
        return new ResourceGroupId(this.segments.get(0));
    }

    public Optional<ResourceGroupId> getParent() {
        if (this.segments.size() == 1) {
            return Optional.empty();
        }
        return Optional.of(new ResourceGroupId(this.segments.subList(0, this.segments.size() - 1)));
    }

    public boolean isAncestorOf(ResourceGroupId descendant) {
        List<String> descendantSegments = descendant.getSegments();
        if (this.segments.size() >= descendantSegments.size()) {
            return false;
        }
        return descendantSegments.subList(0, this.segments.size()).equals(this.segments);
    }

    private static void checkArgument(boolean argument, String format, Object ... args) {
        if (!argument) {
            throw new IllegalArgumentException(String.format(format, args));
        }
    }

    @JsonValue
    public String toString() {
        return this.segments.stream().collect(Collectors.joining("."));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceGroupId that = (ResourceGroupId)o;
        return Objects.equals(this.segments, that.segments);
    }

    public int hashCode() {
        return Objects.hash(this.segments);
    }
}

