/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.block.AbstractArrayElementBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilderStatus;

public class ArrayElementBlockWriter
extends AbstractArrayElementBlock
implements BlockBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ArrayElementBlockWriter.class).instanceSize();
    private final BlockBuilder blockBuilder;
    private final int initialBlockBuilderSize;
    private int positionsWritten;

    public ArrayElementBlockWriter(BlockBuilder blockBuilder, int start) {
        super(start);
        this.blockBuilder = blockBuilder;
        this.initialBlockBuilderSize = blockBuilder.getSizeInBytes();
    }

    @Override
    protected BlockBuilder getBlock() {
        return this.blockBuilder;
    }

    @Override
    public int getSizeInBytes() {
        return this.blockBuilder.getSizeInBytes() - this.initialBlockBuilderSize;
    }

    @Override
    public int getRetainedSizeInBytes() {
        return INSTANCE_SIZE + this.blockBuilder.getRetainedSizeInBytes();
    }

    @Override
    public BlockBuilder writeByte(int value) {
        this.blockBuilder.writeByte(value);
        return this;
    }

    @Override
    public BlockBuilder writeShort(int value) {
        this.blockBuilder.writeShort(value);
        return this;
    }

    @Override
    public BlockBuilder writeInt(int value) {
        this.blockBuilder.writeInt(value);
        return this;
    }

    @Override
    public BlockBuilder writeLong(long value) {
        this.blockBuilder.writeLong(value);
        return this;
    }

    @Override
    public BlockBuilder writeBytes(Slice source, int sourceIndex, int length) {
        this.blockBuilder.writeBytes(source, sourceIndex, length);
        return this;
    }

    @Override
    public BlockBuilder writeObject(Object value) {
        this.blockBuilder.writeObject(value);
        return this;
    }

    @Override
    public BlockBuilder beginBlockEntry() {
        return this.blockBuilder.beginBlockEntry();
    }

    @Override
    public BlockBuilder appendNull() {
        this.blockBuilder.appendNull();
        this.entryAdded();
        return this;
    }

    @Override
    public BlockBuilder closeEntry() {
        this.blockBuilder.closeEntry();
        this.entryAdded();
        return this;
    }

    private void entryAdded() {
        ++this.positionsWritten;
    }

    @Override
    public int getPositionCount() {
        return this.positionsWritten;
    }

    @Override
    public Block build() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockBuilder newBlockBuilderLike(BlockBuilderStatus blockBuilderStatus) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ArrayElementBlockWriter{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }
}

