/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.spi.ErrorCodeSupplier;
import com.facebook.presto.jdbc.internal.spi.PrestoException;
import com.facebook.presto.jdbc.internal.spi.StandardErrorCode;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

public final class MethodHandleUtil {
    private MethodHandleUtil() {
    }

    public static MethodHandle compose(MethodHandle f, MethodHandle g) {
        if (f.type().parameterType(0) != g.type().returnType()) {
            throw new IllegalArgumentException(String.format("f.parameter(0) != g.return(). f: %s  g: %s", f.type(), g.type()));
        }
        MethodHandle fUTS = MethodHandles.dropArguments(f, 1, g.type().parameterList());
        return MethodHandles.foldArguments(fUTS, g);
    }

    public static MethodHandle compose(MethodHandle f, MethodHandle g, MethodHandle h) {
        if (f.type().parameterCount() != 2) {
            throw new IllegalArgumentException(String.format("f.parameterCount != 2. f: %s", f.type()));
        }
        if (f.type().parameterType(0) != g.type().returnType()) {
            throw new IllegalArgumentException(String.format("f.parameter(0) != g.return. f: %s  g: %s", f.type(), g.type()));
        }
        if (f.type().parameterType(1) != h.type().returnType()) {
            throw new IllegalArgumentException(String.format("f.parameter(0) != h.return. f: %s  h: %s", f.type(), h.type()));
        }
        MethodType typeVTU = f.type().dropParameterTypes(0, 1).appendParameterTypes(h.type().parameterList()).appendParameterTypes(new Class[]{f.type().parameterType(0)});
        MethodHandle fVTU = MethodHandles.permuteArguments(f, typeVTU, h.type().parameterCount() + 1, 0);
        MethodHandle fhTU = MethodHandles.foldArguments(fVTU, h);
        int[] reorder = new int[fhTU.type().parameterCount()];
        for (int i = 0; i < reorder.length - 1; ++i) {
            reorder[i] = i + 1 + g.type().parameterCount();
        }
        reorder[reorder.length - 1] = 0;
        MethodType typeUST = f.type().dropParameterTypes(1, 2).appendParameterTypes(g.type().parameterList()).appendParameterTypes(h.type().parameterList());
        MethodHandle fhUST = MethodHandles.permuteArguments(fhTU, typeUST, reorder);
        return MethodHandles.foldArguments(fhUST, g);
    }

    public static MethodHandle methodHandle(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return MethodHandles.lookup().unreflect(clazz.getMethod(name, parameterTypes));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
        }
    }

    public static MethodHandle nativeValueGetter(Type type) {
        MethodHandle methodHandle;
        Class<?> javaType = type.getJavaType();
        if (javaType == Long.TYPE) {
            methodHandle = MethodHandleUtil.methodHandle(Type.class, "getLong", Block.class, Integer.TYPE);
        } else if (javaType == Double.TYPE) {
            methodHandle = MethodHandleUtil.methodHandle(Type.class, "getDouble", Block.class, Integer.TYPE);
        } else if (javaType == Boolean.TYPE) {
            methodHandle = MethodHandleUtil.methodHandle(Type.class, "getBoolean", Block.class, Integer.TYPE);
        } else if (javaType == Slice.class) {
            methodHandle = MethodHandleUtil.methodHandle(Type.class, "getSlice", Block.class, Integer.TYPE);
        } else if (javaType == Block.class) {
            MethodHandle getObjectMethodHandle = MethodHandleUtil.methodHandle(Type.class, "getObject", Block.class, Integer.TYPE);
            methodHandle = getObjectMethodHandle.asType(getObjectMethodHandle.type().changeReturnType(Block.class));
        } else if (javaType == Void.TYPE) {
            methodHandle = MethodHandleUtil.methodHandle(MethodHandleUtil.class, "unknownGetter", Type.class, Block.class, Integer.TYPE);
        } else {
            throw new IllegalArgumentException("Unknown java type " + javaType + " from type " + type);
        }
        return methodHandle.bindTo(type);
    }

    public static Void unknownGetter(Type type, Block block, int position) {
        throw new IllegalArgumentException("For UNKNOWN type, getter should never be invoked on Block");
    }
}

