/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.resourceGroups;

import com.facebook.presto.jdbc.internal.airlift.units.DataSize;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.jdbc.internal.spi.resourceGroups.ResourceGroupState;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ResourceGroupInfo {
    private final ResourceGroupId id;
    private final DataSize softMemoryLimit;
    private final int maxRunningQueries;
    private final int maxQueuedQueries;
    private final ResourceGroupState state;
    private final int numEligibleSubGroups;
    private final DataSize memoryUsage;
    private final int numAggregatedRunningQueries;
    private final int numAggregatedQueuedQueries;
    private final List<ResourceGroupInfo> subGroups;

    @JsonCreator
    public ResourceGroupInfo(@JsonProperty(value="id") ResourceGroupId id, @JsonProperty(value="softMemoryLimit") DataSize softMemoryLimit, @JsonProperty(value="maxRunningQueries") int maxRunningQueries, @JsonProperty(value="maxQueuedQueries") int maxQueuedQueries, @JsonProperty(value="state") ResourceGroupState state, @JsonProperty(value="numEligibleSubGroups") int numEligibleSubGroups, @JsonProperty(value="memoryUsage") DataSize memoryUsage, @JsonProperty(value="numAggregatedRunningQueries") int numAggregatedRunningQueries, @JsonProperty(value="numAggregatedQueuedQueries") int numAggregatedQueuedQueries) {
        this(id, softMemoryLimit, maxRunningQueries, maxQueuedQueries, state, numEligibleSubGroups, memoryUsage, numAggregatedRunningQueries, numAggregatedQueuedQueries, Collections.emptyList());
    }

    public ResourceGroupInfo(ResourceGroupId id, DataSize softMemoryLimit, int maxRunningQueries, int maxQueuedQueries, ResourceGroupState state, int numEligibleSubGroups, DataSize memoryUsage, int numAggregatedRunningQueries, int numAggregatedQueuedQueries, List<ResourceGroupInfo> subGroups) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.softMemoryLimit = Objects.requireNonNull(softMemoryLimit, "softMemoryLimit is null");
        this.maxRunningQueries = maxRunningQueries;
        this.maxQueuedQueries = maxQueuedQueries;
        this.state = Objects.requireNonNull(state, "state is null");
        this.numEligibleSubGroups = numEligibleSubGroups;
        this.memoryUsage = Objects.requireNonNull(memoryUsage, "memoryUsage is null");
        this.numAggregatedRunningQueries = numAggregatedRunningQueries;
        this.numAggregatedQueuedQueries = numAggregatedQueuedQueries;
        this.subGroups = Collections.unmodifiableList(Objects.requireNonNull(subGroups, "subGroups is null"));
    }

    @JsonProperty
    public ResourceGroupId getId() {
        return this.id;
    }

    @JsonProperty
    public DataSize getSoftMemoryLimit() {
        return this.softMemoryLimit;
    }

    @JsonProperty
    public int getMaxRunningQueries() {
        return this.maxRunningQueries;
    }

    @JsonProperty
    public int getMaxQueuedQueries() {
        return this.maxQueuedQueries;
    }

    public List<ResourceGroupInfo> getSubGroups() {
        return this.subGroups;
    }

    @JsonProperty
    public DataSize getMemoryUsage() {
        return this.memoryUsage;
    }

    public Optional<ResourceGroupInfo> getSubGroup(ResourceGroupId resourceGroupId) {
        return this.subGroups.stream().filter(subGroup -> subGroup.getId().equals(resourceGroupId) || subGroup.getId().isAncestorOf(resourceGroupId)).findFirst();
    }

    @JsonProperty
    public int getNumAggregatedRunningQueries() {
        return this.numAggregatedRunningQueries;
    }

    @JsonProperty
    public int getNumAggregatedQueuedQueries() {
        return this.numAggregatedQueuedQueries;
    }

    @JsonProperty
    public ResourceGroupState getState() {
        return this.state;
    }

    @JsonProperty
    public int getNumEligibleSubGroups() {
        return this.numEligibleSubGroups;
    }

    public ResourceGroupInfo createSingleNodeInfo() {
        return new ResourceGroupInfo(this.getId(), this.getSoftMemoryLimit(), this.getMaxRunningQueries(), this.getMaxQueuedQueries(), this.getState(), this.getNumEligibleSubGroups(), this.getMemoryUsage(), this.getNumAggregatedRunningQueries(), this.getNumAggregatedQueuedQueries());
    }
}

