/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client.testing;

import com.facebook.presto.jdbc.internal.airlift.http.client.HeaderName;
import com.facebook.presto.jdbc.internal.airlift.http.client.HttpStatus;
import com.facebook.presto.jdbc.internal.airlift.http.client.Response;
import com.facebook.presto.jdbc.internal.guava.base.MoreObjects;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableListMultimap;
import com.facebook.presto.jdbc.internal.guava.collect.ListMultimap;
import com.facebook.presto.jdbc.internal.guava.io.CountingInputStream;
import com.facebook.presto.jdbc.internal.guava.net.MediaType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;

public class TestingResponse
implements Response {
    private final HttpStatus status;
    private final ListMultimap<HeaderName, String> headers;
    private final CountingInputStream countingInputStream;

    public TestingResponse(HttpStatus status, ListMultimap<String, String> headers, byte[] bytes) {
        this(status, headers, new ByteArrayInputStream(Objects.requireNonNull(bytes, "bytes is null")));
    }

    public TestingResponse(HttpStatus status, ListMultimap<String, String> headers, InputStream input) {
        this.status = Objects.requireNonNull(status, "status is null");
        this.headers = ImmutableListMultimap.copyOf(TestingResponse.toHeaderMap(Objects.requireNonNull(headers, "headers is null")));
        this.countingInputStream = new CountingInputStream(Objects.requireNonNull(input, "input is null"));
    }

    @Override
    public int getStatusCode() {
        return this.status.code();
    }

    @Override
    public String getStatusMessage() {
        return this.status.reason();
    }

    @Override
    public ListMultimap<HeaderName, String> getHeaders() {
        return this.headers;
    }

    @Override
    public long getBytesRead() {
        return this.countingInputStream.getCount();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.countingInputStream;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("statusCode", this.getStatusCode()).add("statusMessage", this.getStatusMessage()).add("headers", this.getHeaders()).toString();
    }

    public static ListMultimap<String, String> contentType(MediaType type) {
        return ImmutableListMultimap.of("Content-Type", type.toString());
    }

    public static Response mockResponse(HttpStatus status, MediaType type, String content) {
        return new TestingResponse(status, TestingResponse.contentType(type), content.getBytes(StandardCharsets.UTF_8));
    }

    private static ListMultimap<HeaderName, String> toHeaderMap(ListMultimap<String, String> headers) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (Map.Entry entry : headers.entries()) {
            builder.put(HeaderName.of((String)entry.getKey()), entry.getValue());
        }
        return builder.build();
    }
}

