/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.block.AbstractMapBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockUtil;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.util.Objects;

public class MapBlock
extends AbstractMapBlock {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MapBlock.class).instanceSize();
    private final int startOffset;
    private final int positionCount;
    private final boolean[] mapIsNull;
    private final int[] offsets;
    private final Block keyBlock;
    private final Block valueBlock;
    private final int[] hashTables;
    private int sizeInBytes;
    private final int retainedSizeInBytes;

    public MapBlock(int startOffset, int positionCount, boolean[] mapIsNull, int[] offsets, Block keyBlock, Block valueBlock, int[] hashTables, Type keyType, MethodHandle keyBlockNativeEquals, MethodHandle keyNativeHashCode) {
        super(keyType, keyNativeHashCode, keyBlockNativeEquals);
        this.startOffset = startOffset;
        this.positionCount = positionCount;
        this.mapIsNull = mapIsNull;
        this.offsets = Objects.requireNonNull(offsets, "offsets is null");
        this.keyBlock = Objects.requireNonNull(keyBlock, "keyBlock is null");
        this.valueBlock = Objects.requireNonNull(valueBlock, "valueBlock is null");
        if (keyBlock.getPositionCount() != valueBlock.getPositionCount()) {
            throw new IllegalArgumentException(String.format("keyBlock and valueBlock has different size: %s %s", keyBlock.getPositionCount(), valueBlock.getPositionCount()));
        }
        if (hashTables.length < keyBlock.getPositionCount() * 2) {
            throw new IllegalArgumentException(String.format("keyBlock/valueBlock size does not match hash table size: %s %s", keyBlock.getPositionCount(), hashTables.length));
        }
        this.hashTables = hashTables;
        this.sizeInBytes = -1;
        this.retainedSizeInBytes = BlockUtil.intSaturatedCast((long)(INSTANCE_SIZE + keyBlock.getRetainedSizeInBytes() + valueBlock.getRetainedSizeInBytes()) + SizeOf.sizeOf(offsets) + SizeOf.sizeOf(mapIsNull) + SizeOf.sizeOf(hashTables));
    }

    @Override
    protected Block getKeys() {
        return this.keyBlock;
    }

    @Override
    protected Block getValues() {
        return this.valueBlock;
    }

    @Override
    protected int[] getHashTables() {
        return this.hashTables;
    }

    @Override
    protected int[] getOffsets() {
        return this.offsets;
    }

    @Override
    protected int getOffsetBase() {
        return this.startOffset;
    }

    @Override
    protected boolean[] getMapIsNull() {
        return this.mapIsNull;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getSizeInBytes() {
        if (this.sizeInBytes < 0) {
            this.calculateSize();
        }
        return this.sizeInBytes;
    }

    private void calculateSize() {
        int entriesStart = this.offsets[this.startOffset];
        int entriesEnd = this.offsets[this.startOffset + this.positionCount];
        int entryCount = entriesEnd - entriesStart;
        this.sizeInBytes = this.keyBlock.getRegionSizeInBytes(entriesStart, entryCount) + this.valueBlock.getRegionSizeInBytes(entriesStart, entryCount) + 5 * this.positionCount + 8 * entryCount;
    }

    @Override
    public int getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MapBlock{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }
}

