/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.block.AbstractSingleMapBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;

public class SingleMapBlockWriter
extends AbstractSingleMapBlock
implements BlockBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleMapBlockWriter.class).instanceSize();
    private final BlockBuilder keyBlockBuilder;
    private final BlockBuilder valueBlockBuilder;
    private final int initialBlockBuilderSize;
    private int positionsWritten;
    private boolean writeToValueNext;

    SingleMapBlockWriter(int start, BlockBuilder keyBlockBuilder, BlockBuilder valueBlockBuilder) {
        super(start, keyBlockBuilder, valueBlockBuilder);
        this.keyBlockBuilder = keyBlockBuilder;
        this.valueBlockBuilder = valueBlockBuilder;
        this.initialBlockBuilderSize = keyBlockBuilder.getSizeInBytes() + valueBlockBuilder.getSizeInBytes();
    }

    @Override
    public int getSizeInBytes() {
        return this.keyBlockBuilder.getSizeInBytes() + this.valueBlockBuilder.getSizeInBytes() - this.initialBlockBuilderSize;
    }

    @Override
    public int getRetainedSizeInBytes() {
        return INSTANCE_SIZE + this.keyBlockBuilder.getRetainedSizeInBytes() + this.valueBlockBuilder.getRetainedSizeInBytes();
    }

    @Override
    public BlockBuilder writeByte(int value) {
        if (this.writeToValueNext) {
            this.valueBlockBuilder.writeByte(value);
        } else {
            this.keyBlockBuilder.writeByte(value);
        }
        return this;
    }

    @Override
    public BlockBuilder writeShort(int value) {
        if (this.writeToValueNext) {
            this.valueBlockBuilder.writeShort(value);
        } else {
            this.keyBlockBuilder.writeShort(value);
        }
        return this;
    }

    @Override
    public BlockBuilder writeInt(int value) {
        if (this.writeToValueNext) {
            this.valueBlockBuilder.writeInt(value);
        } else {
            this.keyBlockBuilder.writeInt(value);
        }
        return this;
    }

    @Override
    public BlockBuilder writeLong(long value) {
        if (this.writeToValueNext) {
            this.valueBlockBuilder.writeLong(value);
        } else {
            this.keyBlockBuilder.writeLong(value);
        }
        return this;
    }

    @Override
    public BlockBuilder writeBytes(Slice source, int sourceIndex, int length) {
        if (this.writeToValueNext) {
            this.valueBlockBuilder.writeBytes(source, sourceIndex, length);
        } else {
            this.keyBlockBuilder.writeBytes(source, sourceIndex, length);
        }
        return this;
    }

    @Override
    public BlockBuilder writeObject(Object value) {
        if (this.writeToValueNext) {
            this.valueBlockBuilder.writeObject(value);
        } else {
            this.keyBlockBuilder.writeObject(value);
        }
        return this;
    }

    @Override
    public BlockBuilder beginBlockEntry() {
        BlockBuilder result = this.writeToValueNext ? this.valueBlockBuilder.beginBlockEntry() : this.keyBlockBuilder.beginBlockEntry();
        return result;
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.writeToValueNext) {
            this.valueBlockBuilder.appendNull();
        } else {
            this.keyBlockBuilder.appendNull();
        }
        this.entryAdded();
        return this;
    }

    @Override
    public BlockBuilder closeEntry() {
        if (this.writeToValueNext) {
            this.valueBlockBuilder.closeEntry();
        } else {
            this.keyBlockBuilder.closeEntry();
        }
        this.entryAdded();
        return this;
    }

    private void entryAdded() {
        this.writeToValueNext = !this.writeToValueNext;
        ++this.positionsWritten;
    }

    @Override
    public int getPositionCount() {
        return this.positionsWritten;
    }

    @Override
    public BlockEncoding getEncoding() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block build() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockBuilder newBlockBuilderLike(BlockBuilderStatus blockBuilderStatus) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SingleMapBlockWriter{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }
}

