/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.type;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceUtf8;
import com.facebook.presto.jdbc.internal.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import com.facebook.presto.jdbc.internal.spi.type.VarcharType;
import java.util.Objects;

public final class Varchars {
    private Varchars() {
    }

    public static boolean isVarcharType(Type type) {
        return type instanceof VarcharType;
    }

    public static Slice truncateToLength(Slice slice, Type type) {
        Objects.requireNonNull(type, "type is null");
        if (!Varchars.isVarcharType(type)) {
            throw new IllegalArgumentException("type must be the instance of VarcharType");
        }
        return Varchars.truncateToLength(slice, (VarcharType)VarcharType.class.cast(type));
    }

    public static Slice truncateToLength(Slice slice, VarcharType varcharType) {
        Objects.requireNonNull(varcharType, "varcharType is null");
        return Varchars.truncateToLength(slice, varcharType.getLength());
    }

    public static Slice truncateToLength(Slice slice, int maxLength) {
        Objects.requireNonNull(slice, "slice is null");
        if (maxLength < 0) {
            throw new IllegalArgumentException("Max length must be greater or equal than zero");
        }
        if (maxLength == 0) {
            return Slices.EMPTY_SLICE;
        }
        int sizeInBytes = slice.length();
        if (sizeInBytes <= maxLength) {
            return slice;
        }
        int indexEnd = SliceUtf8.offsetOfCodePoint(slice, maxLength);
        if (indexEnd < 0) {
            return slice;
        }
        return slice.slice(0, indexEnd);
    }
}

