/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import java.util.List;

public abstract class AbstractSingleMapBlock
implements Block {
    private final int offset;
    private final Block keyBlock;
    private final Block valueBlock;

    public AbstractSingleMapBlock(int offset, Block keyBlock, Block valueBlock) {
        this.offset = offset;
        this.keyBlock = keyBlock;
        this.valueBlock = valueBlock;
    }

    private int getAbsolutePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
        return position + this.offset;
    }

    @Override
    public boolean isNull(int position) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            if (this.keyBlock.isNull(position / 2)) {
                throw new IllegalStateException("Map key is null");
            }
            return false;
        }
        return this.valueBlock.isNull(position / 2);
    }

    @Override
    public byte getByte(int position, int offset) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.keyBlock.getByte(position / 2, offset);
        }
        return this.valueBlock.getByte(position / 2, offset);
    }

    @Override
    public short getShort(int position, int offset) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.keyBlock.getShort(position / 2, offset);
        }
        return this.valueBlock.getShort(position / 2, offset);
    }

    @Override
    public int getInt(int position, int offset) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.keyBlock.getInt(position / 2, offset);
        }
        return this.valueBlock.getInt(position / 2, offset);
    }

    @Override
    public long getLong(int position, int offset) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.keyBlock.getLong(position / 2, offset);
        }
        return this.valueBlock.getLong(position / 2, offset);
    }

    @Override
    public Slice getSlice(int position, int offset, int length) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.keyBlock.getSlice(position / 2, offset, length);
        }
        return this.valueBlock.getSlice(position / 2, offset, length);
    }

    @Override
    public int getSliceLength(int position) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.keyBlock.getSliceLength(position / 2);
        }
        return this.valueBlock.getSliceLength(position / 2);
    }

    @Override
    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.keyBlock.bytesEqual(position / 2, offset, otherSlice, otherOffset, length);
        }
        return this.valueBlock.bytesEqual(position / 2, offset, otherSlice, otherOffset, length);
    }

    @Override
    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.keyBlock.bytesCompare(position / 2, offset, length, otherSlice, otherOffset, otherLength);
        }
        return this.valueBlock.bytesCompare(position / 2, offset, length, otherSlice, otherOffset, otherLength);
    }

    @Override
    public void writeBytesTo(int position, int offset, int length, BlockBuilder blockBuilder) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            this.keyBlock.writeBytesTo(position / 2, offset, length, blockBuilder);
        } else {
            this.valueBlock.writeBytesTo(position / 2, offset, length, blockBuilder);
        }
    }

    @Override
    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.keyBlock.equals(position / 2, offset, otherBlock, otherPosition, otherOffset, length);
        }
        return this.valueBlock.equals(position / 2, offset, otherBlock, otherPosition, otherOffset, length);
    }

    @Override
    public long hash(int position, int offset, int length) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.keyBlock.hash(position / 2, offset, length);
        }
        return this.valueBlock.hash(position / 2, offset, length);
    }

    @Override
    public <T> T getObject(int position, Class<T> clazz) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.keyBlock.getObject(position / 2, clazz);
        }
        return this.valueBlock.getObject(position / 2, clazz);
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            this.keyBlock.writePositionTo(position / 2, blockBuilder);
        } else {
            this.valueBlock.writePositionTo(position / 2, blockBuilder);
        }
    }

    @Override
    public Block getSingleValueBlock(int position) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.keyBlock.getSingleValueBlock(position / 2);
        }
        return this.valueBlock.getSingleValueBlock(position / 2);
    }

    @Override
    public int getRegionSizeInBytes(int position, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block copyPositions(List<Integer> positions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block copyRegion(int position, int length) {
        throw new UnsupportedOperationException();
    }
}

