/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.BlockUtil;
import com.facebook.presto.jdbc.internal.spi.block.DictionaryBlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.DictionaryId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class DictionaryBlock
implements Block {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DictionaryBlock.class).instanceSize();
    private final int positionCount;
    private final Block dictionary;
    private final int idsOffset;
    private final int[] ids;
    private final int retainedSizeInBytes;
    private volatile int sizeInBytes = -1;
    private volatile int uniqueIds = -1;
    private final DictionaryId dictionarySourceId;

    public DictionaryBlock(int positionCount, Block dictionary, int[] ids) {
        this(0, positionCount, dictionary, ids, false, DictionaryId.randomDictionaryId());
    }

    public DictionaryBlock(int positionCount, Block dictionary, int[] ids, DictionaryId dictionaryId) {
        this(0, positionCount, dictionary, ids, false, dictionaryId);
    }

    public DictionaryBlock(int positionCount, Block dictionary, int[] ids, boolean dictionaryIsCompacted) {
        this(0, positionCount, dictionary, ids, dictionaryIsCompacted, DictionaryId.randomDictionaryId());
    }

    public DictionaryBlock(int positionCount, Block dictionary, int[] ids, boolean dictionaryIsCompacted, DictionaryId dictionarySourceId) {
        this(0, positionCount, dictionary, ids, dictionaryIsCompacted, dictionarySourceId);
    }

    private DictionaryBlock(int idsOffset, int positionCount, Block dictionary, int[] ids, boolean dictionaryIsCompacted, DictionaryId dictionarySourceId) {
        Objects.requireNonNull(dictionary, "dictionary is null");
        Objects.requireNonNull(ids, "ids is null");
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.idsOffset = idsOffset;
        if (ids.length - idsOffset < positionCount) {
            throw new IllegalArgumentException("ids length is less than positionCount");
        }
        this.positionCount = positionCount;
        this.dictionary = dictionary;
        this.ids = ids;
        this.dictionarySourceId = Objects.requireNonNull(dictionarySourceId, "dictionarySourceId is null");
        this.retainedSizeInBytes = Math.toIntExact((long)(INSTANCE_SIZE + dictionary.getRetainedSizeInBytes()) + SizeOf.sizeOf(ids));
        if (dictionaryIsCompacted) {
            this.sizeInBytes = this.retainedSizeInBytes;
            this.uniqueIds = dictionary.getPositionCount();
        }
    }

    @Override
    public int getSliceLength(int position) {
        return this.dictionary.getSliceLength(this.getId(position));
    }

    @Override
    public byte getByte(int position, int offset) {
        return this.dictionary.getByte(this.getId(position), offset);
    }

    @Override
    public short getShort(int position, int offset) {
        return this.dictionary.getShort(this.getId(position), offset);
    }

    @Override
    public int getInt(int position, int offset) {
        return this.dictionary.getInt(this.getId(position), offset);
    }

    @Override
    public long getLong(int position, int offset) {
        return this.dictionary.getLong(this.getId(position), offset);
    }

    @Override
    public Slice getSlice(int position, int offset, int length) {
        return this.dictionary.getSlice(this.getId(position), offset, length);
    }

    @Override
    public <T> T getObject(int position, Class<T> clazz) {
        return this.dictionary.getObject(this.getId(position), clazz);
    }

    @Override
    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        return this.dictionary.bytesEqual(this.getId(position), offset, otherSlice, otherOffset, length);
    }

    @Override
    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        return this.dictionary.bytesCompare(this.getId(position), offset, length, otherSlice, otherOffset, otherLength);
    }

    @Override
    public void writeBytesTo(int position, int offset, int length, BlockBuilder blockBuilder) {
        this.dictionary.writeBytesTo(this.getId(position), offset, length, blockBuilder);
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.dictionary.writePositionTo(this.getId(position), blockBuilder);
    }

    @Override
    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        return this.dictionary.equals(this.getId(position), offset, otherBlock, otherPosition, otherOffset, length);
    }

    @Override
    public long hash(int position, int offset, int length) {
        return this.dictionary.hash(this.getId(position), offset, length);
    }

    @Override
    public int compareTo(int leftPosition, int leftOffset, int leftLength, Block rightBlock, int rightPosition, int rightOffset, int rightLength) {
        return this.dictionary.compareTo(this.getId(leftPosition), leftOffset, leftLength, rightBlock, rightPosition, rightOffset, rightLength);
    }

    @Override
    public Block getSingleValueBlock(int position) {
        return this.dictionary.getSingleValueBlock(this.getId(position));
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getSizeInBytes() {
        if (this.sizeInBytes < 0) {
            this.calculateCompactSize();
        }
        return this.sizeInBytes;
    }

    private void calculateCompactSize() {
        int sizeInBytes = 0;
        int uniqueIds = 0;
        boolean[] seen = new boolean[this.dictionary.getPositionCount()];
        for (int i = 0; i < this.positionCount; ++i) {
            int position = this.getId(i);
            if (seen[position]) continue;
            if (!this.dictionary.isNull(position)) {
                sizeInBytes += this.dictionary.getRegionSizeInBytes(position, 1);
            }
            ++uniqueIds;
            seen[position] = true;
        }
        this.sizeInBytes = sizeInBytes + this.positionCount * 4;
        this.uniqueIds = uniqueIds;
    }

    @Override
    public int getRegionSizeInBytes(int positionOffset, int length) {
        if (positionOffset == 0 && length == this.getPositionCount()) {
            return this.getSizeInBytes();
        }
        int sizeInBytes = 0;
        boolean[] seen = new boolean[this.dictionary.getPositionCount()];
        for (int i = positionOffset; i < positionOffset + length; ++i) {
            int position = this.getId(i);
            if (seen[position]) continue;
            if (!this.dictionary.isNull(position)) {
                sizeInBytes += this.dictionary.getRegionSizeInBytes(position, 1);
            }
            seen[position] = true;
        }
        return sizeInBytes + length * 4;
    }

    @Override
    public int getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public BlockEncoding getEncoding() {
        return new DictionaryBlockEncoding(this.dictionary.getEncoding());
    }

    @Override
    public Block copyPositions(List<Integer> positions) {
        BlockUtil.checkValidPositions(positions, this.positionCount);
        ArrayList<Integer> positionsToCopy = new ArrayList<Integer>();
        HashMap<Integer, Integer> oldIndexToNewIndex = new HashMap<Integer, Integer>();
        int[] newIds = new int[positions.size()];
        for (int i = 0; i < positions.size(); ++i) {
            int oldIndex = this.getId(positions.get(i));
            if (!oldIndexToNewIndex.containsKey(oldIndex)) {
                oldIndexToNewIndex.put(oldIndex, positionsToCopy.size());
                positionsToCopy.add(oldIndex);
            }
            newIds[i] = (Integer)oldIndexToNewIndex.get(oldIndex);
        }
        return new DictionaryBlock(positions.size(), this.dictionary.copyPositions(positionsToCopy), newIds);
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        if (positionOffset < 0 || length < 0 || positionOffset + length > this.positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + this.positionCount + " positions");
        }
        return new DictionaryBlock(this.idsOffset + positionOffset, length, this.dictionary, this.ids, false, DictionaryId.randomDictionaryId());
    }

    @Override
    public Block copyRegion(int position, int length) {
        if (position < 0 || length < 0 || position + length > this.positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + position + " in block with " + this.positionCount + " positions");
        }
        int[] newIds = Arrays.copyOfRange(this.ids, this.idsOffset + position, this.idsOffset + position + length);
        DictionaryBlock dictionaryBlock = new DictionaryBlock(length, this.dictionary, newIds);
        return dictionaryBlock.compact();
    }

    @Override
    public boolean isNull(int position) {
        return this.dictionary.isNull(this.getId(position));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DictionaryBlock{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }

    public Block getDictionary() {
        return this.dictionary;
    }

    Slice getIds() {
        return Slices.wrappedIntArray(this.ids, this.idsOffset, this.positionCount);
    }

    public int getId(int position) {
        if (position < 0 || position >= this.positionCount) {
            throw new IllegalArgumentException("Invalid position " + position + " in block with " + this.positionCount + " positions");
        }
        return this.ids[position + this.idsOffset];
    }

    public DictionaryId getDictionarySourceId() {
        return this.dictionarySourceId;
    }

    public boolean isCompact() {
        if (this.uniqueIds < 0) {
            this.calculateCompactSize();
        }
        return this.uniqueIds == this.dictionary.getPositionCount();
    }

    public DictionaryBlock compact() {
        if (this.isCompact()) {
            return this;
        }
        int dictionarySize = this.dictionary.getPositionCount();
        ArrayList<Integer> dictionaryPositionsToCopy = new ArrayList<Integer>(Math.min(dictionarySize, this.positionCount));
        int[] remapIndex = new int[dictionarySize];
        Arrays.fill(remapIndex, -1);
        int newIndex = 0;
        for (int i = 0; i < this.positionCount; ++i) {
            int dictionaryIndex = this.getId(i);
            if (remapIndex[dictionaryIndex] != -1) continue;
            dictionaryPositionsToCopy.add(dictionaryIndex);
            remapIndex[dictionaryIndex] = newIndex++;
        }
        if (dictionaryPositionsToCopy.size() == dictionarySize) {
            return this;
        }
        int[] newIds = new int[this.positionCount];
        for (int i = 0; i < this.positionCount; ++i) {
            int newId = remapIndex[this.getId(i)];
            if (newId == -1) {
                throw new IllegalStateException("reference to a non-existent key");
            }
            newIds[i] = newId;
        }
        try {
            Block compactDictionary = this.dictionary.copyPositions(dictionaryPositionsToCopy);
            return new DictionaryBlock(this.positionCount, compactDictionary, newIds, true);
        }
        catch (UnsupportedOperationException e) {
            return this;
        }
    }
}

