/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.statistics;

import com.facebook.presto.jdbc.internal.spi.statistics.Estimate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class ColumnStatistics {
    private final Map<String, Estimate> statistics;
    private static final String DATA_SIZE_STATISTIC_KEY = "data_size";
    private static final String NULLS_COUNT_STATISTIC_KEY = "nulls_count";
    private static final String DISTINCT_VALUES_STATITIC_KEY = "distinct_values_count";

    private ColumnStatistics(Estimate dataSize, Estimate nullsCount, Estimate distinctValuesCount) {
        Objects.requireNonNull(dataSize, "dataSize can not be null");
        this.statistics = ColumnStatistics.createStatisticsMap(dataSize, nullsCount, distinctValuesCount);
    }

    private static Map<String, Estimate> createStatisticsMap(Estimate dataSize, Estimate nullsCount, Estimate distinctValuesCount) {
        HashMap<String, Estimate> statistics = new HashMap<String, Estimate>();
        statistics.put(DATA_SIZE_STATISTIC_KEY, dataSize);
        statistics.put(NULLS_COUNT_STATISTIC_KEY, nullsCount);
        statistics.put(DISTINCT_VALUES_STATITIC_KEY, distinctValuesCount);
        return Collections.unmodifiableMap(statistics);
    }

    public Estimate getDataSize() {
        return this.statistics.get(DATA_SIZE_STATISTIC_KEY);
    }

    public Estimate getNullsCount() {
        return this.statistics.get(NULLS_COUNT_STATISTIC_KEY);
    }

    public Estimate getDistinctValuesCount() {
        return this.statistics.get(DISTINCT_VALUES_STATITIC_KEY);
    }

    public Map<String, Estimate> getStatistics() {
        return this.statistics;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Estimate dataSize = Estimate.unknownValue();
        private Estimate nullsCount = Estimate.unknownValue();
        private Estimate distinctValuesCount = Estimate.unknownValue();

        public Builder setDataSize(Estimate dataSize) {
            this.dataSize = Objects.requireNonNull(dataSize, "dataSize can not be null");
            return this;
        }

        public Builder setNullsCount(Estimate nullsCount) {
            this.nullsCount = nullsCount;
            return this;
        }

        public Builder setDistinctValuesCount(Estimate distinctValuesCount) {
            this.distinctValuesCount = distinctValuesCount;
            return this;
        }

        public ColumnStatistics build() {
            return new ColumnStatistics(this.dataSize, this.nullsCount, this.distinctValuesCount);
        }
    }
}

