/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.MapBlock;
import com.facebook.presto.jdbc.internal.spi.block.MapBlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.SingleMapBlock;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public abstract class AbstractMapBlock
implements Block {
    static final int HASH_MULTIPLIER = 2;
    protected final Type keyType;
    protected final MethodHandle keyNativeHashCode;
    protected final MethodHandle keyBlockNativeEquals;

    public AbstractMapBlock(Type keyType, MethodHandle keyNativeHashCode, MethodHandle keyBlockNativeEquals) {
        this.keyType = Objects.requireNonNull(keyType, "keyType is null");
        this.keyNativeHashCode = keyNativeHashCode;
        this.keyBlockNativeEquals = keyBlockNativeEquals;
    }

    protected abstract Block getKeys();

    protected abstract Block getValues();

    protected abstract int[] getHashTables();

    protected abstract int[] getOffsets();

    protected abstract int getOffsetBase();

    protected abstract boolean[] getMapIsNull();

    private int getOffset(int position) {
        return this.getOffsets()[position + this.getOffsetBase()];
    }

    @Override
    public BlockEncoding getEncoding() {
        return new MapBlockEncoding(this.keyType, this.keyBlockNativeEquals, this.keyNativeHashCode, this.getKeys().getEncoding(), this.getValues().getEncoding());
    }

    @Override
    public Block copyPositions(List<Integer> positions) {
        int[] newOffsets = new int[positions.size() + 1];
        boolean[] newMapIsNull = new boolean[positions.size()];
        ArrayList<Integer> entriesPositions = new ArrayList<Integer>();
        int newPosition = 0;
        for (int position : positions) {
            if (this.isNull(position)) {
                newMapIsNull[newPosition] = true;
                newOffsets[newPosition + 1] = newOffsets[newPosition];
            } else {
                int entriesStartOffset = this.getOffset(position);
                int entriesEndOffset = this.getOffset(position + 1);
                int entryCount = entriesEndOffset - entriesStartOffset;
                newOffsets[newPosition + 1] = newOffsets[newPosition] + entryCount;
                for (int elementIndex = entriesStartOffset; elementIndex < entriesEndOffset; ++elementIndex) {
                    entriesPositions.add(elementIndex);
                }
            }
            ++newPosition;
        }
        int[] hashTable = this.getHashTables();
        int[] newHashTable = new int[newOffsets[newOffsets.length - 1] * 2];
        int newHashIndex = 0;
        for (int position : positions) {
            int entriesStartOffset = this.getOffset(position);
            int entriesEndOffset = this.getOffset(position + 1);
            for (int hashIndex = entriesStartOffset * 2; hashIndex < entriesEndOffset * 2; ++hashIndex) {
                newHashTable[newHashIndex] = hashTable[hashIndex];
                ++newHashIndex;
            }
        }
        Block newKeys = this.getKeys().copyPositions(entriesPositions);
        Block newValues = this.getValues().copyPositions(entriesPositions);
        return new MapBlock(0, positions.size(), newMapIsNull, newOffsets, newKeys, newValues, newHashTable, this.keyType, this.keyBlockNativeEquals, this.keyNativeHashCode);
    }

    @Override
    public Block getRegion(int position, int length) {
        int positionCount = this.getPositionCount();
        if (position < 0 || length < 0 || position + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + position + " in block with " + positionCount + " positions");
        }
        if (position == 0 && length == positionCount) {
            return this;
        }
        return new MapBlock(position + this.getOffsetBase(), length, this.getMapIsNull(), this.getOffsets(), this.getKeys(), this.getValues(), this.getHashTables(), this.keyType, this.keyBlockNativeEquals, this.keyNativeHashCode);
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        int positionCount = this.getPositionCount();
        if (position < 0 || length < 0 || position + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + position + " in block with " + positionCount + " positions");
        }
        int entriesStart = this.getOffsets()[this.getOffsetBase() + position];
        int entriesEnd = this.getOffsets()[this.getOffsetBase() + position + length];
        int entryCount = entriesEnd - entriesStart;
        return this.getKeys().getRegionSizeInBytes(entriesStart, entryCount) + this.getValues().getRegionSizeInBytes(entriesStart, entryCount) + (long)(5 * length) + (long)(8 * entryCount);
    }

    @Override
    public Block copyRegion(int position, int length) {
        int positionCount = this.getPositionCount();
        if (position < 0 || length < 0 || position + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + position + " in block with " + positionCount + " positions");
        }
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + length);
        Block newKeys = this.getKeys().copyRegion(startValueOffset, endValueOffset - startValueOffset);
        Block newValues = this.getValues().copyRegion(startValueOffset, endValueOffset - startValueOffset);
        int[] newOffsets = new int[length + 1];
        for (int i = 1; i < newOffsets.length; ++i) {
            newOffsets[i] = this.getOffset(position + i) - startValueOffset;
        }
        boolean[] newValueIsNull = Arrays.copyOfRange(this.getMapIsNull(), position + this.getOffsetBase(), position + this.getOffsetBase() + length);
        int[] newHashTable = Arrays.copyOfRange(this.getHashTables(), startValueOffset * 2, endValueOffset * 2);
        return new MapBlock(0, length, newValueIsNull, newOffsets, newKeys, newValues, newHashTable, this.keyType, this.keyBlockNativeEquals, this.keyNativeHashCode);
    }

    @Override
    public <T> T getObject(int position, Class<T> clazz) {
        if (clazz != Block.class) {
            throw new IllegalArgumentException("clazz must be Block.class");
        }
        this.checkReadablePosition(position);
        int startEntryOffset = this.getOffset(position);
        int endEntryOffset = this.getOffset(position + 1);
        return clazz.cast(new SingleMapBlock(startEntryOffset * 2, (endEntryOffset - startEntryOffset) * 2, this.getKeys(), this.getValues(), this.getHashTables(), this.keyType, this.keyNativeHashCode, this.keyBlockNativeEquals));
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        BlockBuilder entryBuilder = blockBuilder.beginBlockEntry();
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + 1);
        for (int i = startValueOffset; i < endValueOffset; ++i) {
            if (this.getKeys().isNull(i)) {
                entryBuilder.appendNull();
            } else {
                this.getKeys().writePositionTo(i, entryBuilder);
                entryBuilder.closeEntry();
            }
            if (this.getValues().isNull(i)) {
                entryBuilder.appendNull();
                continue;
            }
            this.getValues().writePositionTo(i, entryBuilder);
            entryBuilder.closeEntry();
        }
    }

    @Override
    public Block getSingleValueBlock(int position) {
        this.checkReadablePosition(position);
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + 1);
        int valueLength = endValueOffset - startValueOffset;
        Block newKeys = this.getKeys().copyRegion(startValueOffset, valueLength);
        Block newValues = this.getValues().copyRegion(startValueOffset, valueLength);
        int[] newHashTable = Arrays.copyOfRange(this.getHashTables(), startValueOffset * 2, endValueOffset * 2);
        return new MapBlock(0, 1, new boolean[]{this.isNull(position)}, new int[]{0, valueLength}, newKeys, newValues, newHashTable, this.keyType, this.keyBlockNativeEquals, this.keyNativeHashCode);
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.getMapIsNull()[position + this.getOffsetBase()];
    }

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }
}

