/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.block.AbstractInterleavedBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.InterleavedBlockEncoding;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;

public class InterleavedBlock
extends AbstractInterleavedBlock {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(InterleavedBlock.class).instanceSize();
    private final Block[] blocks;
    private final InterleavedBlockEncoding blockEncoding;
    private final int start;
    private final int positionCount;
    private final long retainedSizeInBytes;
    private final AtomicLong sizeInBytes;

    public InterleavedBlock(Block[] blocks) {
        super(blocks.length);
        this.blocks = blocks;
        long sizeInBytes = 0L;
        long retainedSizeInBytes = INSTANCE_SIZE;
        int positionCount = 0;
        int firstSubBlockPositionCount = blocks[0].getPositionCount();
        for (int i = 0; i < this.getBlockCount(); ++i) {
            sizeInBytes += blocks[i].getSizeInBytes();
            retainedSizeInBytes += blocks[i].getRetainedSizeInBytes();
            positionCount += blocks[i].getPositionCount();
            if (firstSubBlockPositionCount == blocks[i].getPositionCount()) continue;
            throw new IllegalArgumentException("length of sub blocks differ: block 0: " + firstSubBlockPositionCount + ", block " + i + ": " + blocks[i].getPositionCount());
        }
        this.blockEncoding = this.computeBlockEncoding();
        this.start = 0;
        this.positionCount = positionCount;
        this.sizeInBytes = new AtomicLong(sizeInBytes);
        this.retainedSizeInBytes = retainedSizeInBytes;
    }

    private InterleavedBlock(Block[] blocks, int start, int positionCount, long retainedSizeInBytes, InterleavedBlockEncoding blockEncoding) {
        super(blocks.length);
        this.blocks = blocks;
        this.start = start;
        this.positionCount = positionCount;
        this.retainedSizeInBytes = retainedSizeInBytes;
        this.blockEncoding = blockEncoding;
        this.sizeInBytes = new AtomicLong(-1L);
    }

    @Override
    public Block getRegion(int position, int length) {
        this.validateRange(position, length);
        return new InterleavedBlock(this.blocks, this.toAbsolutePosition(position), length, this.retainedSizeInBytes, this.blockEncoding);
    }

    @Override
    protected Block getBlock(int blockIndex) {
        if (blockIndex < 0) {
            throw new IllegalArgumentException("position is not valid");
        }
        return this.blocks[blockIndex];
    }

    @Override
    protected int toAbsolutePosition(int position) {
        return position + this.start;
    }

    @Override
    public InterleavedBlockEncoding getEncoding() {
        return this.blockEncoding;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        long sizeInBytes = this.sizeInBytes.get();
        if (sizeInBytes < 0L) {
            sizeInBytes = 0L;
            for (int i = 0; i < this.getBlockCount(); ++i) {
                sizeInBytes += this.blocks[i].getRegionSizeInBytes(this.start / this.blocks.length, this.positionCount / this.blocks.length);
            }
            this.sizeInBytes.set(sizeInBytes);
        }
        return sizeInBytes;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.blocks, this.retainedSizeInBytes - (long)INSTANCE_SIZE);
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("InterleavedBlock{");
        sb.append("columns=").append(this.getBlockCount());
        sb.append(", positionCountPerBlock=").append(this.getPositionCount() / this.getBlockCount());
        sb.append('}');
        return sb.toString();
    }
}

