/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.BlockUtil;
import com.facebook.presto.jdbc.internal.spi.block.LongArrayBlock;
import com.facebook.presto.jdbc.internal.spi.block.LongArrayBlockEncoding;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;

public class LongArrayBlockBuilder
implements BlockBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LongArrayBlockBuilder.class).instanceSize();
    @Nullable
    private BlockBuilderStatus blockBuilderStatus;
    private boolean initialized;
    private int initialEntryCount;
    private int positionCount;
    private boolean[] valueIsNull = new boolean[0];
    private long[] values = new long[0];
    private long retainedSizeInBytes;

    public LongArrayBlockBuilder(@Nullable BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this.blockBuilderStatus = blockBuilderStatus;
        this.initialEntryCount = Math.max(expectedEntries, 1);
        this.updateDataSize();
    }

    @Override
    public BlockBuilder writeLong(long value) {
        if (this.values.length <= this.positionCount) {
            this.growCapacity();
        }
        this.values[this.positionCount] = value;
        ++this.positionCount;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(9);
        }
        return this;
    }

    @Override
    public BlockBuilder closeEntry() {
        return this;
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.values.length <= this.positionCount) {
            this.growCapacity();
        }
        this.valueIsNull[this.positionCount] = true;
        ++this.positionCount;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(9);
        }
        return this;
    }

    @Override
    public Block build() {
        return new LongArrayBlock(this.positionCount, this.valueIsNull, this.values);
    }

    @Override
    public BlockBuilder newBlockBuilderLike(BlockBuilderStatus blockBuilderStatus) {
        return new LongArrayBlockBuilder(blockBuilderStatus, BlockUtil.calculateBlockResetSize(this.positionCount));
    }

    private void growCapacity() {
        int newSize;
        if (this.initialized) {
            newSize = BlockUtil.calculateNewArraySize(this.values.length);
        } else {
            newSize = this.initialEntryCount;
            this.initialized = true;
        }
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.values = Arrays.copyOf(this.values, newSize);
        this.updateDataSize();
    }

    private void updateDataSize() {
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf(this.valueIsNull) + SizeOf.sizeOf(this.values);
        if (this.blockBuilderStatus != null) {
            this.retainedSizeInBytes += (long)BlockBuilderStatus.INSTANCE_SIZE;
        }
    }

    @Override
    public long getSizeInBytes() {
        return 9 * this.positionCount;
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        return 9 * length;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.values, SizeOf.sizeOf(this.values));
        consumer.accept(this.valueIsNull, SizeOf.sizeOf(this.valueIsNull));
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getLong(int position, int offset) {
        this.checkReadablePosition(position);
        if (offset != 0) {
            throw new IllegalArgumentException("offset must be zero");
        }
        return this.values[position];
    }

    @Override
    @Deprecated
    public int getInt(int position, int offset) {
        this.checkReadablePosition(position);
        if (offset != 0) {
            throw new IllegalArgumentException("offset must be zero");
        }
        return Math.toIntExact(this.values[position]);
    }

    @Override
    @Deprecated
    public short getShort(int position, int offset) {
        this.checkReadablePosition(position);
        if (offset != 0) {
            throw new IllegalArgumentException("offset must be zero");
        }
        short value = (short)this.values[position];
        if ((long)value != this.values[position]) {
            throw new ArithmeticException("short overflow");
        }
        return value;
    }

    @Override
    @Deprecated
    public byte getByte(int position, int offset) {
        this.checkReadablePosition(position);
        if (offset != 0) {
            throw new IllegalArgumentException("offset must be zero");
        }
        byte value = (byte)this.values[position];
        if ((long)value != this.values[position]) {
            throw new ArithmeticException("byte overflow");
        }
        return value;
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.valueIsNull[position];
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        blockBuilder.writeLong(this.values[position]);
    }

    @Override
    public Block getSingleValueBlock(int position) {
        this.checkReadablePosition(position);
        return new LongArrayBlock(1, new boolean[]{this.valueIsNull[position]}, new long[]{this.values[position]});
    }

    @Override
    public Block copyPositions(List<Integer> positions) {
        boolean[] newValueIsNull = new boolean[positions.size()];
        long[] newValues = new long[positions.size()];
        for (int i = 0; i < positions.size(); ++i) {
            int position = positions.get(i);
            this.checkReadablePosition(position);
            newValueIsNull[i] = this.valueIsNull[position];
            newValues[i] = this.values[position];
        }
        return new LongArrayBlock(positions.size(), newValueIsNull, newValues);
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new LongArrayBlock(positionOffset, length, this.valueIsNull, this.values);
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        boolean[] newValueIsNull = Arrays.copyOfRange(this.valueIsNull, positionOffset, positionOffset + length);
        long[] newValues = Arrays.copyOfRange(this.values, positionOffset, positionOffset + length);
        return new LongArrayBlock(length, newValueIsNull, newValues);
    }

    @Override
    public BlockEncoding getEncoding() {
        return new LongArrayBlockEncoding();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LongArrayBlockBuilder{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }
}

