/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.type;

import com.facebook.presto.jdbc.internal.spi.ConnectorSession;
import com.facebook.presto.jdbc.internal.spi.ErrorCodeSupplier;
import com.facebook.presto.jdbc.internal.spi.PrestoException;
import com.facebook.presto.jdbc.internal.spi.StandardErrorCode;
import com.facebook.presto.jdbc.internal.spi.block.ArrayBlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.spi.block.InterleavedBlockBuilder;
import com.facebook.presto.jdbc.internal.spi.type.AbstractType;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import com.facebook.presto.jdbc.internal.spi.type.TypeSignature;
import com.facebook.presto.jdbc.internal.spi.type.TypeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class RowType
extends AbstractType {
    private final List<RowField> fields;
    private final List<Type> fieldTypes;

    public RowType(List<Type> fieldTypes, Optional<List<String>> fieldNames) {
        super(RowType.toTypeSignature(fieldTypes, fieldNames), Block.class);
        ArrayList<RowField> fields = new ArrayList<RowField>();
        for (int i = 0; i < fieldTypes.size(); ++i) {
            int index = i;
            fields.add(new RowField(fieldTypes.get(i), fieldNames.map(names -> (String)names.get(index))));
        }
        this.fields = fields;
        this.fieldTypes = fieldTypes;
    }

    private static TypeSignature toTypeSignature(List<Type> fieldTypes, Optional<List<String>> fieldNames) {
        int size = fieldTypes.size();
        if (size == 0) {
            throw new IllegalArgumentException("Row type must have at least 1 field");
        }
        ArrayList<TypeSignature> elementTypeSignatures = new ArrayList<TypeSignature>();
        ArrayList<String> literalParameters = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            elementTypeSignatures.add(fieldTypes.get(i).getTypeSignature());
            if (!fieldNames.isPresent()) continue;
            literalParameters.add(fieldNames.get().get(i));
        }
        return new TypeSignature("row", elementTypeSignatures, literalParameters);
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        return new ArrayBlockBuilder(new InterleavedBlockBuilder(this.getTypeParameters(), blockBuilderStatus, expectedEntries * this.getTypeParameters().size(), expectedBytesPerEntry), blockBuilderStatus, expectedEntries);
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return new ArrayBlockBuilder(new InterleavedBlockBuilder(this.getTypeParameters(), blockBuilderStatus, expectedEntries * this.getTypeParameters().size()), blockBuilderStatus, expectedEntries);
    }

    @Override
    public String getDisplayName() {
        StringBuilder result = new StringBuilder();
        result.append("row").append('(');
        for (RowField field : this.fields) {
            String typeDisplayName = field.getType().getDisplayName();
            if (field.getName().isPresent()) {
                result.append(field.getName().get()).append(' ').append(typeDisplayName);
            } else {
                result.append(typeDisplayName);
            }
            result.append(", ");
        }
        result.setLength(result.length() - 2);
        result.append(')');
        return result.toString();
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        Block arrayBlock = this.getObject(block, position);
        ArrayList<Object> values = new ArrayList<Object>(arrayBlock.getPositionCount());
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            values.add(this.fields.get(i).getType().getObjectValue(session, arrayBlock, i));
        }
        return Collections.unmodifiableList(values);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeObject(block.getObject(position, Block.class));
            blockBuilder.closeEntry();
        }
    }

    @Override
    public Block getObject(Block block, int position) {
        return block.getObject(position, Block.class);
    }

    @Override
    public void writeObject(BlockBuilder blockBuilder, Object value) {
        blockBuilder.writeObject(value).closeEntry();
    }

    @Override
    public List<Type> getTypeParameters() {
        return this.fieldTypes;
    }

    public List<RowField> getFields() {
        return this.fields;
    }

    @Override
    public boolean isComparable() {
        return this.fields.stream().allMatch(field -> field.getType().isComparable());
    }

    @Override
    public boolean isOrderable() {
        return this.fields.stream().allMatch(field -> field.getType().isOrderable());
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        Block leftRow = leftBlock.getObject(leftPosition, Block.class);
        Block rightRow = rightBlock.getObject(rightPosition, Block.class);
        for (int i = 0; i < leftRow.getPositionCount(); ++i) {
            RowType.checkElementNotNull(leftRow.isNull(i));
            RowType.checkElementNotNull(rightRow.isNull(i));
            Type fieldType = this.fields.get(i).getType();
            if (fieldType.equalTo(leftRow, i, rightRow, i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        Block leftRow = leftBlock.getObject(leftPosition, Block.class);
        Block rightRow = rightBlock.getObject(rightPosition, Block.class);
        for (int i = 0; i < leftRow.getPositionCount(); ++i) {
            RowType.checkElementNotNull(leftRow.isNull(i));
            RowType.checkElementNotNull(rightRow.isNull(i));
            Type fieldType = this.fields.get(i).getType();
            if (!fieldType.isOrderable()) {
                throw new UnsupportedOperationException(fieldType.getTypeSignature() + " type is not orderable");
            }
            int compareResult = fieldType.compareTo(leftRow, i, rightRow, i);
            if (compareResult == 0) continue;
            return compareResult;
        }
        return 0;
    }

    @Override
    public long hash(Block block, int position) {
        Block arrayBlock = block.getObject(position, Block.class);
        long result = 1L;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            Type elementType = this.fields.get(i).getType();
            result = 31L * result + TypeUtils.hashPosition(elementType, arrayBlock, i);
        }
        return result;
    }

    private static void checkElementNotNull(boolean isNull) {
        if (isNull) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "ROW comparison not supported for fields with null elements");
        }
    }

    public static class RowField {
        private final Type type;
        private final Optional<String> name;

        public RowField(Type type, Optional<String> name) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.name = Objects.requireNonNull(name, "name is null");
        }

        public Type getType() {
            return this.type;
        }

        public Optional<String> getName() {
            return this.name;
        }
    }
}

