/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.spi.block.AbstractArrayBlock;
import com.facebook.presto.jdbc.internal.spi.block.AbstractInterleavedBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.DictionaryBlock;
import com.facebook.presto.jdbc.internal.spi.block.RunLengthEncodedBlock;
import java.util.Objects;

public final class ColumnarRow {
    private final Block nullCheckBlock;
    private final Block[] fields;

    public static ColumnarRow toColumnarRow(Block block) {
        Objects.requireNonNull(block, "block is null");
        if (block instanceof DictionaryBlock) {
            return ColumnarRow.toColumnarRow((DictionaryBlock)block);
        }
        if (block instanceof RunLengthEncodedBlock) {
            return ColumnarRow.toColumnarRow((RunLengthEncodedBlock)block);
        }
        if (!(block instanceof AbstractArrayBlock)) {
            throw new IllegalArgumentException("Invalid row block");
        }
        AbstractArrayBlock arrayBlock = (AbstractArrayBlock)block;
        Block arrayBlockValues = arrayBlock.getValues();
        if (!(arrayBlockValues instanceof AbstractInterleavedBlock)) {
            throw new IllegalArgumentException("Invalid row block");
        }
        AbstractInterleavedBlock interleavedBlock = (AbstractInterleavedBlock)arrayBlockValues;
        int interleavedBlockOffset = 0;
        int interleavedBlockLength = 0;
        if (arrayBlock.getPositionCount() > 0) {
            interleavedBlockOffset = arrayBlock.getOffset(0);
            interleavedBlockLength = arrayBlock.getOffset(arrayBlock.getPositionCount()) - interleavedBlockOffset;
        }
        Block[] fields = interleavedBlock.computeSerializableSubBlocks(interleavedBlockOffset, interleavedBlockLength);
        return new ColumnarRow(block, fields);
    }

    private static ColumnarRow toColumnarRow(DictionaryBlock dictionaryBlock) {
        Block dictionary = dictionaryBlock.getDictionary();
        int[] newDictionaryIndex = new int[dictionary.getPositionCount()];
        int nextNewDictionaryIndex = 0;
        for (int position = 0; position < dictionary.getPositionCount(); ++position) {
            if (dictionary.isNull(position)) continue;
            newDictionaryIndex[position] = nextNewDictionaryIndex++;
        }
        int[] dictionaryIds = new int[dictionaryBlock.getPositionCount()];
        int nonNullPositionCount = 0;
        for (int position = 0; position < dictionaryBlock.getPositionCount(); ++position) {
            if (dictionaryBlock.isNull(position)) continue;
            int oldDictionaryId = dictionaryBlock.getId(position);
            dictionaryIds[nonNullPositionCount] = newDictionaryIndex[oldDictionaryId];
            ++nonNullPositionCount;
        }
        ColumnarRow columnarRow = ColumnarRow.toColumnarRow(dictionaryBlock.getDictionary());
        Block[] fields = new Block[columnarRow.getFieldCount()];
        for (int i = 0; i < columnarRow.getFieldCount(); ++i) {
            fields[i] = new DictionaryBlock(nonNullPositionCount, columnarRow.getField(i), dictionaryIds);
        }
        return new ColumnarRow(dictionaryBlock, fields);
    }

    private static ColumnarRow toColumnarRow(RunLengthEncodedBlock rleBlock) {
        Block rleValue = rleBlock.getValue();
        ColumnarRow columnarRow = ColumnarRow.toColumnarRow(rleValue);
        Block[] fields = new Block[columnarRow.getFieldCount()];
        for (int i = 0; i < columnarRow.getFieldCount(); ++i) {
            Block nullSuppressedField = columnarRow.getField(i);
            if (rleValue.isNull(0)) {
                if (nullSuppressedField.getPositionCount() != 0) {
                    throw new IllegalArgumentException("Invalid row block");
                }
                fields[i] = nullSuppressedField;
                continue;
            }
            fields[i] = new RunLengthEncodedBlock(nullSuppressedField, rleBlock.getPositionCount());
        }
        return new ColumnarRow(rleBlock, fields);
    }

    private ColumnarRow(Block nullCheckBlock, Block[] fields) {
        this.nullCheckBlock = nullCheckBlock;
        this.fields = (Block[])fields.clone();
    }

    public int getPositionCount() {
        return this.nullCheckBlock.getPositionCount();
    }

    public boolean isNull(int position) {
        return this.nullCheckBlock.isNull(position);
    }

    public int getFieldCount() {
        return this.fields.length;
    }

    public Block getField(int index) {
        return this.fields[index];
    }
}

