/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.statistics;

import com.facebook.presto.jdbc.internal.spi.statistics.Estimate;
import java.util.Objects;

public final class ColumnStatistics {
    private final Estimate dataSize;
    private final Estimate nullsCount;
    private final Estimate distinctValuesCount;

    private ColumnStatistics(Estimate dataSize, Estimate nullsCount, Estimate distinctValuesCount) {
        this.dataSize = Objects.requireNonNull(dataSize, "dataSize can not be null");
        this.nullsCount = Objects.requireNonNull(nullsCount, "nullsCount can not be null");
        this.distinctValuesCount = Objects.requireNonNull(distinctValuesCount, "distinctValuesCount can not be null");
    }

    public Estimate getDataSize() {
        return this.dataSize;
    }

    public Estimate getNullsCount() {
        return this.nullsCount;
    }

    public Estimate getDistinctValuesCount() {
        return this.distinctValuesCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Estimate dataSize = Estimate.unknownValue();
        private Estimate nullsCount = Estimate.unknownValue();
        private Estimate distinctValuesCount = Estimate.unknownValue();

        public Builder setDataSize(Estimate dataSize) {
            this.dataSize = dataSize;
            return this;
        }

        public Builder setNullsCount(Estimate nullsCount) {
            this.nullsCount = nullsCount;
            return this;
        }

        public Builder setDistinctValuesCount(Estimate distinctValuesCount) {
            this.distinctValuesCount = distinctValuesCount;
            return this;
        }

        public ColumnStatistics build() {
            return new ColumnStatistics(this.dataSize, this.nullsCount, this.distinctValuesCount);
        }
    }
}

