/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.DynamicSliceOutput;
import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.block.AbstractFixedWidthBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.spi.block.BlockUtil;
import com.facebook.presto.jdbc.internal.spi.block.FixedWidthBlock;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;

public class FixedWidthBlockBuilder
extends AbstractFixedWidthBlock
implements BlockBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(FixedWidthBlockBuilder.class).instanceSize();
    @Nullable
    private BlockBuilderStatus blockBuilderStatus;
    private boolean initialized;
    private int initialEntryCount;
    private SliceOutput sliceOutput = new DynamicSliceOutput(0);
    private SliceOutput valueIsNull = new DynamicSliceOutput(0);
    private int positionCount;
    private int currentEntrySize;

    public FixedWidthBlockBuilder(int fixedSize, @Nullable BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        super(fixedSize);
        this.blockBuilderStatus = blockBuilderStatus;
        this.initialEntryCount = expectedEntries;
    }

    public FixedWidthBlockBuilder(int fixedSize, int positionCount) {
        super(fixedSize);
        this.initialized = true;
        Slice slice = Slices.allocate(fixedSize * positionCount);
        this.blockBuilderStatus = new BlockBuilderStatus();
        this.sliceOutput = slice.getOutput();
        this.valueIsNull = Slices.allocate(positionCount).getOutput();
    }

    @Override
    protected Slice getRawSlice() {
        return this.sliceOutput.getUnderlyingSlice();
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        return (long)this.sliceOutput.size() + (long)this.valueIsNull.size();
    }

    @Override
    public long getRetainedSizeInBytes() {
        long size = INSTANCE_SIZE + this.sliceOutput.getRetainedSize() + this.valueIsNull.getRetainedSize();
        if (this.blockBuilderStatus != null) {
            size += (long)BlockBuilderStatus.INSTANCE_SIZE;
        }
        return size;
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.sliceOutput, Long.valueOf(this.sliceOutput.getRetainedSize()));
        consumer.accept(this.valueIsNull, Long.valueOf(this.valueIsNull.getRetainedSize()));
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    public Block copyPositions(List<Integer> positions) {
        BlockUtil.checkValidPositions(positions, this.positionCount);
        SliceOutput newSlice = Slices.allocate(positions.size() * this.fixedSize).getOutput();
        SliceOutput newValueIsNull = Slices.allocate(positions.size()).getOutput();
        for (int position : positions) {
            newValueIsNull.appendByte(this.valueIsNull.getUnderlyingSlice().getByte(position));
            newSlice.appendBytes(this.getRawSlice().getBytes(position * this.fixedSize, this.fixedSize));
        }
        return new FixedWidthBlock(this.fixedSize, positions.size(), newSlice.slice(), newValueIsNull.slice());
    }

    @Override
    public BlockBuilder writeByte(int value) {
        this.checkCapacity();
        this.sliceOutput.writeByte(value);
        ++this.currentEntrySize;
        return this;
    }

    @Override
    public BlockBuilder writeShort(int value) {
        this.checkCapacity();
        this.sliceOutput.writeShort(value);
        this.currentEntrySize += 2;
        return this;
    }

    @Override
    public BlockBuilder writeInt(int value) {
        this.checkCapacity();
        this.sliceOutput.writeInt(value);
        this.currentEntrySize += 4;
        return this;
    }

    @Override
    public BlockBuilder writeLong(long value) {
        this.checkCapacity();
        this.sliceOutput.writeLong(value);
        this.currentEntrySize += 8;
        return this;
    }

    @Override
    public BlockBuilder writeBytes(Slice source, int sourceIndex, int length) {
        if (length != this.fixedSize) {
            throw new IllegalStateException("Expected entry size to be exactly " + this.fixedSize + " but was " + this.currentEntrySize);
        }
        this.checkCapacity();
        this.sliceOutput.writeBytes(source, sourceIndex, length);
        this.currentEntrySize += length;
        return this;
    }

    @Override
    public BlockBuilder closeEntry() {
        if (this.currentEntrySize != this.fixedSize) {
            throw new IllegalStateException("Expected entry size to be exactly " + this.fixedSize + " but was " + this.currentEntrySize);
        }
        this.entryAdded(false);
        this.currentEntrySize = 0;
        return this;
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.currentEntrySize > 0) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        this.checkCapacity();
        this.sliceOutput.writeZero(this.fixedSize);
        this.entryAdded(true);
        return this;
    }

    private void entryAdded(boolean isNull) {
        this.checkCapacity();
        this.valueIsNull.appendByte(isNull ? 1 : 0);
        ++this.positionCount;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(1 + this.fixedSize);
        }
    }

    private void checkCapacity() {
        if (!this.initialized) {
            this.initializeCapacity();
        }
    }

    private void initializeCapacity() {
        if (this.positionCount != 0 || this.currentEntrySize != 0) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " was used before initialization");
        }
        int initialSliceOutputSize = (int)Math.min((long)this.fixedSize * (long)this.initialEntryCount, 0x7FFFFFF7L);
        this.sliceOutput = new DynamicSliceOutput(initialSliceOutputSize);
        this.valueIsNull = new DynamicSliceOutput(this.initialEntryCount);
        this.initialized = true;
    }

    @Override
    protected boolean isEntryNull(int position) {
        return this.valueIsNull.getUnderlyingSlice().getByte(position) != 0;
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + positionCount + " positions");
        }
        Slice newSlice = this.sliceOutput.slice().slice(positionOffset * this.fixedSize, length * this.fixedSize);
        Slice newValueIsNull = this.valueIsNull.slice().slice(positionOffset, length);
        return new FixedWidthBlock(this.fixedSize, length, newSlice, newValueIsNull);
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + positionCount + " positions");
        }
        Slice newSlice = Slices.copyOf(this.sliceOutput.getUnderlyingSlice(), positionOffset * this.fixedSize, length * this.fixedSize);
        Slice newValueIsNull = Slices.copyOf(this.valueIsNull.getUnderlyingSlice(), positionOffset, length);
        return new FixedWidthBlock(this.fixedSize, length, newSlice, newValueIsNull);
    }

    @Override
    public Block build() {
        if (this.currentEntrySize > 0) {
            throw new IllegalStateException("Current entry must be closed before the block can be built");
        }
        return new FixedWidthBlock(this.fixedSize, this.positionCount, this.sliceOutput.slice(), this.valueIsNull.slice());
    }

    @Override
    public BlockBuilder newBlockBuilderLike(BlockBuilderStatus blockBuilderStatus) {
        return new FixedWidthBlockBuilder(this.fixedSize, blockBuilderStatus, BlockUtil.calculateBlockResetSize(this.positionCount));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FixedWidthBlockBuilder{");
        sb.append("positionCount=").append(this.positionCount);
        sb.append(", fixedSize=").append(this.fixedSize);
        sb.append(", size=").append(this.sliceOutput.size());
        sb.append('}');
        return sb.toString();
    }
}

