/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SliceInput;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncodingFactory;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncodingSerde;
import com.facebook.presto.jdbc.internal.spi.block.SingleRowBlock;
import com.facebook.presto.jdbc.internal.spi.type.TypeManager;
import java.util.Objects;

public class SingleRowBlockEncoding
implements BlockEncoding {
    public static final BlockEncodingFactory<SingleRowBlockEncoding> FACTORY = new SingleRowBlockEncodingFactory();
    private static final String NAME = "ROW_ELEMENT";
    private final BlockEncoding[] fieldBlockEncodings;

    public SingleRowBlockEncoding(BlockEncoding[] fieldBlockEncodings) {
        this.fieldBlockEncodings = Objects.requireNonNull(fieldBlockEncodings, "fieldBlockEncodings is null");
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(SliceOutput sliceOutput, Block block) {
        SingleRowBlock singleRowBlock = (SingleRowBlock)block;
        int fieldOffset = singleRowBlock.getOffset() / this.fieldBlockEncodings.length;
        for (int i = 0; i < this.fieldBlockEncodings.length; ++i) {
            this.fieldBlockEncodings[i].writeBlock(sliceOutput, singleRowBlock.getFieldBlock(i).getRegion(fieldOffset, 1));
        }
    }

    @Override
    public Block readBlock(SliceInput sliceInput) {
        Block[] fieldBlocks = new Block[this.fieldBlockEncodings.length];
        for (int i = 0; i < fieldBlocks.length; ++i) {
            fieldBlocks[i] = this.fieldBlockEncodings[i].readBlock(sliceInput);
        }
        return new SingleRowBlock(0, fieldBlocks);
    }

    @Override
    public BlockEncodingFactory getFactory() {
        return FACTORY;
    }

    public static class SingleRowBlockEncodingFactory
    implements BlockEncodingFactory<SingleRowBlockEncoding> {
        @Override
        public String getName() {
            return SingleRowBlockEncoding.NAME;
        }

        @Override
        public SingleRowBlockEncoding readEncoding(TypeManager typeManager, BlockEncodingSerde serde, SliceInput input) {
            int numFields = input.readInt();
            BlockEncoding[] fieldBlockEncodings = new BlockEncoding[numFields];
            for (int i = 0; i < numFields; ++i) {
                fieldBlockEncodings[i] = serde.readBlockEncoding(input);
            }
            return new SingleRowBlockEncoding(fieldBlockEncodings);
        }

        @Override
        public void writeEncoding(BlockEncodingSerde serde, SliceOutput output, SingleRowBlockEncoding blockEncoding) {
            output.appendInt(blockEncoding.fieldBlockEncodings.length);
            for (BlockEncoding fieldBlockEncoding : blockEncoding.fieldBlockEncodings) {
                serde.writeBlockEncoding(output, fieldBlockEncoding);
            }
        }
    }
}

