/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.statistics;

import java.util.Objects;
import java.util.function.Function;

public final class Estimate {
    private static final double UNKNOWN_VALUE = Double.NaN;
    private final double value;

    public static final Estimate unknownValue() {
        return new Estimate(Double.NaN);
    }

    public Estimate(double value) {
        this.value = value;
    }

    public static final Estimate zeroValue() {
        return new Estimate(0.0);
    }

    public boolean isValueUnknown() {
        return Double.isNaN(this.value);
    }

    public double getValue() {
        return this.value;
    }

    public Estimate map(Function<Double, Double> mappingFunction) {
        if (this.isValueUnknown()) {
            return this;
        }
        return new Estimate(mappingFunction.apply(this.value));
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Estimate estimate = (Estimate)o;
        return Double.compare(estimate.value, this.value) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

