package com.facebook.presto.jdbc.internal.jackson.datatype.joda.ser;

import java.io.IOException;

import com.facebook.presto.jdbc.internal.jackson.core.JsonGenerator;

import com.facebook.presto.jdbc.internal.jackson.databind.SerializationFeature;
import com.facebook.presto.jdbc.internal.jackson.databind.SerializerProvider;
import com.facebook.presto.jdbc.internal.jackson.datatype.joda.cfg.FormatConfig;
import com.facebook.presto.jdbc.internal.jackson.datatype.joda.cfg.JacksonJodaDateFormat;

import com.facebook.presto.jdbc.internal.joda.time.*;
import com.facebook.presto.jdbc.internal.joda.time.format.DateTimeFormatter;

public class IntervalSerializer extends JodaDateSerializerBase<Interval>
{
    private static final long serialVersionUID = 1L;

    public IntervalSerializer() { this(FormatConfig.DEFAULT_DATETIME_PRINTER); }
    public IntervalSerializer(JacksonJodaDateFormat format) {
        super(Interval.class, format, false,
                SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS);
    }

    @Override
    public IntervalSerializer withFormat(JacksonJodaDateFormat formatter) {
        return (_format == formatter) ? this : new IntervalSerializer(formatter);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Interval value) {
        return (value.getStartMillis() == value.getEndMillis());
    }

    @Override
    public void serialize(Interval interval, JsonGenerator gen, SerializerProvider provider) throws IOException
    {
        // 19-Nov-2014, tatu: Support textual representation similar to what Joda uses
        //   (and why not exact one? In future we'll make it configurable)
        String repr;
        if (_useTimestamp(provider)) {
            // !!! TODO: maybe allow textual format too?
            repr = interval.getStartMillis() + "-" + interval.getEndMillis();
        } else {
            DateTimeFormatter f = _format.createFormatter(provider);
            repr = f.print(interval.getStart()) + "/" + f.print(interval.getEnd());
        }
        gen.writeString(repr);
    }
}
