/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.DictionaryBlock;
import com.facebook.presto.jdbc.internal.spi.block.DictionaryId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class Page {
    private final Block[] blocks;
    private final int positionCount;
    private final AtomicLong sizeInBytes = new AtomicLong(-1L);
    private final AtomicLong retainedSizeInBytes = new AtomicLong(-1L);

    public Page(Block ... blocks) {
        this(Page.determinePositionCount(blocks), blocks);
    }

    public Page(int positionCount, Block ... blocks) {
        Objects.requireNonNull(blocks, "blocks is null");
        this.blocks = Arrays.copyOf(blocks, blocks.length);
        this.positionCount = positionCount;
    }

    public int getChannelCount() {
        return this.blocks.length;
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public long getSizeInBytes() {
        long sizeInBytes = this.sizeInBytes.get();
        if (sizeInBytes < 0L) {
            sizeInBytes = 0L;
            for (Block block : this.blocks) {
                sizeInBytes += block.getSizeInBytes();
            }
            this.sizeInBytes.set(sizeInBytes);
        }
        return sizeInBytes;
    }

    public long getRetainedSizeInBytes() {
        long retainedSizeInBytes = this.retainedSizeInBytes.get();
        if (retainedSizeInBytes < 0L) {
            retainedSizeInBytes = 0L;
            for (Block block : this.blocks) {
                retainedSizeInBytes += block.getRetainedSizeInBytes();
            }
            this.retainedSizeInBytes.set(retainedSizeInBytes);
        }
        return retainedSizeInBytes;
    }

    public Block[] getBlocks() {
        return (Block[])this.blocks.clone();
    }

    public Block getBlock(int channel) {
        return this.blocks[channel];
    }

    public Page getRegion(int positionOffset, int length) {
        if (positionOffset < 0 || length < 0 || positionOffset + length > this.positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in page with " + this.positionCount + " positions");
        }
        int channelCount = this.getChannelCount();
        Block[] slicedBlocks = new Block[channelCount];
        for (int i = 0; i < channelCount; ++i) {
            slicedBlocks[i] = this.blocks[i].getRegion(positionOffset, length);
        }
        return new Page(length, slicedBlocks);
    }

    public void compact() {
        if (this.getRetainedSizeInBytes() <= this.getSizeInBytes()) {
            return;
        }
        for (int i = 0; i < this.blocks.length; ++i) {
            Block block = this.blocks[i];
            if (block instanceof DictionaryBlock) continue;
            this.blocks[i] = block.copyRegion(0, block.getPositionCount());
        }
        Map<DictionaryId, DictionaryBlockIndexes> dictionaryBlocks = this.getRelatedDictionaryBlocks();
        for (DictionaryBlockIndexes blockIndexes : dictionaryBlocks.values()) {
            List<DictionaryBlock> compactBlocks = Page.compactRelatedBlocks(blockIndexes.getBlocks());
            List<Integer> indexes = blockIndexes.getIndexes();
            for (int i = 0; i < compactBlocks.size(); ++i) {
                this.blocks[indexes.get((int)i).intValue()] = compactBlocks.get(i);
            }
        }
        long retainedSize = 0L;
        for (Block block : this.blocks) {
            retainedSize += block.getRetainedSizeInBytes();
        }
        this.retainedSizeInBytes.set(retainedSize);
    }

    private Map<DictionaryId, DictionaryBlockIndexes> getRelatedDictionaryBlocks() {
        HashMap<DictionaryId, DictionaryBlockIndexes> relatedDictionaryBlocks = new HashMap<DictionaryId, DictionaryBlockIndexes>();
        for (int i = 0; i < this.blocks.length; ++i) {
            Block block = this.blocks[i];
            if (!(block instanceof DictionaryBlock)) continue;
            DictionaryBlock dictionaryBlock = (DictionaryBlock)block;
            relatedDictionaryBlocks.computeIfAbsent(dictionaryBlock.getDictionarySourceId(), id -> new DictionaryBlockIndexes()).addBlock(dictionaryBlock, i);
        }
        return relatedDictionaryBlocks;
    }

    private static List<DictionaryBlock> compactRelatedBlocks(List<DictionaryBlock> blocks) {
        DictionaryBlock firstDictionaryBlock = blocks.get(0);
        Block dictionary = firstDictionaryBlock.getDictionary();
        int positionCount = firstDictionaryBlock.getPositionCount();
        int dictionarySize = dictionary.getPositionCount();
        ArrayList<Integer> dictionaryPositionsToCopy = new ArrayList<Integer>(Math.min(dictionarySize, positionCount));
        int[] remapIndex = new int[dictionarySize];
        Arrays.fill(remapIndex, -1);
        int newIndex = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = firstDictionaryBlock.getId(i);
            if (remapIndex[position] != -1) continue;
            dictionaryPositionsToCopy.add(position);
            remapIndex[position] = newIndex++;
        }
        if (dictionaryPositionsToCopy.size() == dictionarySize) {
            return blocks;
        }
        int[] newIds = Page.getNewIds(positionCount, firstDictionaryBlock, remapIndex);
        ArrayList<DictionaryBlock> outputDictionaryBlocks = new ArrayList<DictionaryBlock>(blocks.size());
        DictionaryId newDictionaryId = DictionaryId.randomDictionaryId();
        for (DictionaryBlock dictionaryBlock : blocks) {
            if (!firstDictionaryBlock.getDictionarySourceId().equals(dictionaryBlock.getDictionarySourceId())) {
                throw new IllegalArgumentException("dictionarySourceIds must be the same");
            }
            try {
                Block compactDictionary = dictionaryBlock.getDictionary().copyPositions(dictionaryPositionsToCopy);
                outputDictionaryBlocks.add(new DictionaryBlock(positionCount, compactDictionary, newIds, true, newDictionaryId));
            }
            catch (UnsupportedOperationException e) {
                outputDictionaryBlocks.add(dictionaryBlock);
            }
        }
        return outputDictionaryBlocks;
    }

    private static int[] getNewIds(int positionCount, DictionaryBlock dictionaryBlock, int[] remapIndex) {
        int[] newIds = new int[positionCount];
        for (int i = 0; i < positionCount; ++i) {
            int newId = remapIndex[dictionaryBlock.getId(i)];
            if (newId == -1) {
                throw new IllegalStateException("reference to a non-existent key");
            }
            newIds[i] = newId;
        }
        return newIds;
    }

    public void assureLoaded() {
        for (Block block : this.blocks) {
            block.assureLoaded();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Page{");
        builder.append("positions=").append(this.positionCount);
        builder.append(", channels=").append(this.getChannelCount());
        builder.append('}');
        builder.append("@").append(Integer.toHexString(System.identityHashCode(this)));
        return builder.toString();
    }

    private static int determinePositionCount(Block ... blocks) {
        Objects.requireNonNull(blocks, "blocks is null");
        if (blocks.length == 0) {
            throw new IllegalArgumentException("blocks is empty");
        }
        return blocks[0].getPositionCount();
    }

    public Page mask(int[] retainedPositions) {
        Objects.requireNonNull(retainedPositions, "retainedPositions is null");
        Block[] blocks = (Block[])Arrays.stream(this.getBlocks()).map(block -> new DictionaryBlock((Block)block, retainedPositions)).toArray(Block[]::new);
        return new Page(retainedPositions.length, blocks);
    }

    private static class DictionaryBlockIndexes {
        private final List<DictionaryBlock> blocks = new ArrayList<DictionaryBlock>();
        private final List<Integer> indexes = new ArrayList<Integer>();

        private DictionaryBlockIndexes() {
        }

        public void addBlock(DictionaryBlock block, int index) {
            this.blocks.add(block);
            this.indexes.add(index);
        }

        public List<DictionaryBlock> getBlocks() {
            return this.blocks;
        }

        public List<Integer> getIndexes() {
            return this.indexes;
        }
    }
}

