/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockUtil;
import com.facebook.presto.jdbc.internal.spi.block.RunLengthBlockEncoding;
import com.facebook.presto.jdbc.internal.spi.predicate.Utils;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;

public class RunLengthEncodedBlock
implements Block {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(RunLengthEncodedBlock.class).instanceSize();
    private final Block value;
    private final int positionCount;

    public static Block create(Type type, Object value, int positionCount) {
        Block block = Utils.nativeValueToBlock(type, value);
        return new RunLengthEncodedBlock(block, positionCount);
    }

    public RunLengthEncodedBlock(Block value, int positionCount) {
        Objects.requireNonNull(value, "value is null");
        if (value.getPositionCount() != 1) {
            throw new IllegalArgumentException(String.format("Expected value to contain a single position but has %s positions", value.getPositionCount()));
        }
        if (value instanceof RunLengthEncodedBlock) {
            throw new IllegalArgumentException(String.format("Value can not be an instance of a %s", this.getClass().getName()));
        }
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.value = value;
        this.positionCount = positionCount;
    }

    public Block getValue() {
        return this.value;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        return this.value.getSizeInBytes();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.value.getRetainedSizeInBytes();
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.value, this.value.getRetainedSizeInBytes());
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    public RunLengthBlockEncoding getEncoding() {
        return new RunLengthBlockEncoding(this.value.getEncoding());
    }

    @Override
    public Block copyPositions(List<Integer> positions) {
        BlockUtil.checkValidPositions(positions, this.positionCount);
        return new RunLengthEncodedBlock(this.value.copyRegion(0, 1), positions.size());
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        this.checkPositionIndexes(positionOffset, length);
        return new RunLengthEncodedBlock(this.value, length);
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        return this.value.getSizeInBytes();
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        this.checkPositionIndexes(positionOffset, length);
        return new RunLengthEncodedBlock(this.value.copyRegion(0, 1), length);
    }

    @Override
    public int getSliceLength(int position) {
        return this.value.getSliceLength(0);
    }

    @Override
    public byte getByte(int position, int offset) {
        return this.value.getByte(0, offset);
    }

    @Override
    public short getShort(int position, int offset) {
        return this.value.getShort(0, offset);
    }

    @Override
    public int getInt(int position, int offset) {
        return this.value.getInt(0, offset);
    }

    @Override
    public long getLong(int position, int offset) {
        return this.value.getLong(0, offset);
    }

    @Override
    public Slice getSlice(int position, int offset, int length) {
        return this.value.getSlice(0, offset, length);
    }

    @Override
    public <T> T getObject(int position, Class<T> clazz) {
        return this.value.getObject(0, clazz);
    }

    @Override
    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        return this.value.bytesEqual(0, offset, otherSlice, otherOffset, length);
    }

    @Override
    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        return this.value.bytesCompare(0, offset, length, otherSlice, otherOffset, otherLength);
    }

    @Override
    public void writeBytesTo(int position, int offset, int length, BlockBuilder blockBuilder) {
        this.value.writeBytesTo(0, offset, length, blockBuilder);
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.value.writePositionTo(0, blockBuilder);
    }

    @Override
    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        return this.value.equals(0, offset, otherBlock, otherPosition, otherOffset, length);
    }

    @Override
    public long hash(int position, int offset, int length) {
        return this.value.hash(0, offset, length);
    }

    @Override
    public int compareTo(int leftPosition, int leftOffset, int leftLength, Block rightBlock, int rightPosition, int rightOffset, int rightLength) {
        return this.value.compareTo(0, leftOffset, leftLength, rightBlock, rightPosition, rightOffset, rightLength);
    }

    @Override
    public Block getSingleValueBlock(int position) {
        this.checkReadablePosition(position);
        return this.value;
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.value.isNull(0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("positionCount=").append(this.positionCount);
        sb.append(", value=").append(this.value);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void assureLoaded() {
        this.value.assureLoaded();
    }

    private void checkPositionIndexes(int positionOffset, int length) {
        if (positionOffset < 0 || length < 0 || positionOffset + length > this.positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + this.positionCount + " positions");
        }
    }

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.positionCount) {
            throw new IllegalArgumentException("position is not valid");
        }
    }
}

