/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.spi.ConnectorPageSink;
import com.facebook.presto.jdbc.internal.spi.Page;
import com.facebook.presto.jdbc.internal.spi.RecordSink;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.type.DecimalType;
import com.facebook.presto.jdbc.internal.spi.type.Decimals;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class RecordPageSink
implements ConnectorPageSink {
    private final RecordSink recordSink;

    public RecordPageSink(RecordSink recordSink) {
        this.recordSink = Objects.requireNonNull(recordSink, "recordSink is null");
    }

    @Override
    public CompletableFuture<Collection<Slice>> finish() {
        return CompletableFuture.completedFuture(this.recordSink.commit());
    }

    @Override
    public void abort() {
        this.recordSink.rollback();
    }

    @Override
    public CompletableFuture<?> appendPage(Page page) {
        Block[] blocks = page.getBlocks();
        List<Type> columnTypes = this.recordSink.getColumnTypes();
        for (int position = 0; position < page.getPositionCount(); ++position) {
            this.recordSink.beginRecord();
            for (int i = 0; i < blocks.length; ++i) {
                this.writeField(position, blocks[i], columnTypes.get(i));
            }
            this.recordSink.finishRecord();
        }
        return NOT_BLOCKED;
    }

    private void writeField(int position, Block block, Type type) {
        if (block.isNull(position)) {
            this.recordSink.appendNull();
            return;
        }
        if (type instanceof DecimalType) {
            this.recordSink.appendBigDecimal(RecordPageSink.decodeDecimalValue(position, block, (DecimalType)type));
        } else if (type.getJavaType() == Boolean.TYPE) {
            this.recordSink.appendBoolean(type.getBoolean(block, position));
        } else if (type.getJavaType() == Long.TYPE) {
            this.recordSink.appendLong(type.getLong(block, position));
        } else if (type.getJavaType() == Double.TYPE) {
            this.recordSink.appendDouble(type.getDouble(block, position));
        } else if (type.getJavaType() == Slice.class) {
            this.recordSink.appendString(type.getSlice(block, position).getBytes());
        } else {
            this.recordSink.appendObject(type.getObject(block, position));
        }
    }

    private static BigDecimal decodeDecimalValue(int position, Block block, DecimalType type) {
        if (type.isShort()) {
            return RecordPageSink.decodeDecimalValue(type, type.getLong(block, position));
        }
        return RecordPageSink.decodeDecimalValue(type, type.getSlice(block, position));
    }

    private static BigDecimal decodeDecimalValue(DecimalType shortDecimalType, long value) {
        return new BigDecimal(Decimals.toString(value, shortDecimalType.getScale()));
    }

    private static BigDecimal decodeDecimalValue(DecimalType longDecimalType, Slice value) {
        return new BigDecimal(Decimals.toString(value, longDecimalType.getScale()));
    }
}

