/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import java.util.List;

public abstract class AbstractSingleRowBlock
implements Block {
    protected final int startOffset;
    protected final int numFields;

    protected abstract Block getFieldBlock(int var1);

    protected AbstractSingleRowBlock(int startOffset, int numFields) {
        this.startOffset = startOffset;
        this.numFields = numFields;
    }

    private int getAbsolutePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
        return position + this.startOffset;
    }

    @Override
    public boolean isNull(int position) {
        position = this.getAbsolutePosition(position);
        return this.getFieldBlock(position % this.numFields).isNull(position / this.numFields);
    }

    @Override
    public byte getByte(int position, int offset) {
        position = this.getAbsolutePosition(position);
        return this.getFieldBlock(position % this.numFields).getByte(position / this.numFields, offset);
    }

    @Override
    public short getShort(int position, int offset) {
        position = this.getAbsolutePosition(position);
        return this.getFieldBlock(position % this.numFields).getShort(position / this.numFields, offset);
    }

    @Override
    public int getInt(int position, int offset) {
        position = this.getAbsolutePosition(position);
        return this.getFieldBlock(position % this.numFields).getInt(position / this.numFields, offset);
    }

    @Override
    public long getLong(int position, int offset) {
        position = this.getAbsolutePosition(position);
        return this.getFieldBlock(position % this.numFields).getLong(position / this.numFields, offset);
    }

    @Override
    public Slice getSlice(int position, int offset, int length) {
        position = this.getAbsolutePosition(position);
        return this.getFieldBlock(position % this.numFields).getSlice(position / this.numFields, offset, length);
    }

    @Override
    public int getSliceLength(int position) {
        position = this.getAbsolutePosition(position);
        return this.getFieldBlock(position % this.numFields).getSliceLength(position / this.numFields);
    }

    @Override
    public int compareTo(int position, int offset, int length, Block otherBlock, int otherPosition, int otherOffset, int otherLength) {
        position = this.getAbsolutePosition(position);
        return this.getFieldBlock(position % this.numFields).compareTo(position / this.numFields, offset, length, otherBlock, otherPosition, otherOffset, otherLength);
    }

    @Override
    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        position = this.getAbsolutePosition(position);
        return this.getFieldBlock(position % this.numFields).bytesEqual(position / this.numFields, offset, otherSlice, otherOffset, length);
    }

    @Override
    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        position = this.getAbsolutePosition(position);
        return this.getFieldBlock(position % this.numFields).bytesCompare(position / this.numFields, offset, length, otherSlice, otherOffset, otherLength);
    }

    @Override
    public void writeBytesTo(int position, int offset, int length, BlockBuilder blockBuilder) {
        position = this.getAbsolutePosition(position);
        this.getFieldBlock(position % this.numFields).writeBytesTo(position / this.numFields, offset, length, blockBuilder);
    }

    @Override
    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        position = this.getAbsolutePosition(position);
        return this.getFieldBlock(position % this.numFields).equals(position / this.numFields, offset, otherBlock, otherPosition, otherOffset, length);
    }

    @Override
    public long hash(int position, int offset, int length) {
        position = this.getAbsolutePosition(position);
        return this.getFieldBlock(position % this.numFields).hash(position / this.numFields, offset, length);
    }

    @Override
    public <T> T getObject(int position, Class<T> clazz) {
        position = this.getAbsolutePosition(position);
        return this.getFieldBlock(position % this.numFields).getObject(position / this.numFields, clazz);
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        position = this.getAbsolutePosition(position);
        this.getFieldBlock(position % this.numFields).writePositionTo(position / this.numFields, blockBuilder);
    }

    @Override
    public Block getSingleValueBlock(int position) {
        position = this.getAbsolutePosition(position);
        return this.getFieldBlock(position % this.numFields).getSingleValueBlock(position / this.numFields);
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block copyPositions(List<Integer> positions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block copyRegion(int position, int length) {
        throw new UnsupportedOperationException();
    }
}

