/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.security;

import com.facebook.presto.jdbc.internal.spi.SchemaTableName;
import com.facebook.presto.jdbc.internal.spi.security.Identity;
import com.facebook.presto.jdbc.internal.spi.security.PrivilegeInfo;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class GrantInfo {
    private final Set<PrivilegeInfo> privilegeInfo;
    private final Identity grantee;
    private final SchemaTableName schemaTableName;
    private final Optional<Identity> grantor;
    private final Optional<Boolean> withHierarchy;

    public GrantInfo(Set<PrivilegeInfo> privilegeInfo, Identity grantee, SchemaTableName schemaTableName, Optional<Identity> grantor, Optional<Boolean> withHierarchy) {
        this.privilegeInfo = privilegeInfo;
        this.grantee = grantee;
        this.schemaTableName = schemaTableName;
        this.grantor = grantor;
        this.withHierarchy = withHierarchy;
    }

    public Set<PrivilegeInfo> getPrivilegeInfo() {
        return this.privilegeInfo;
    }

    public Identity getIdentity() {
        return this.grantee;
    }

    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    public Optional<Identity> getGrantor() {
        return this.grantor;
    }

    public Optional<Boolean> getWithHierarchy() {
        return this.withHierarchy;
    }

    public int hashCode() {
        return Objects.hash(this.privilegeInfo, this.grantee, this.schemaTableName, this.grantor, this.withHierarchy);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrantInfo grantInfo = (GrantInfo)o;
        return Objects.equals(this.privilegeInfo, grantInfo.getPrivilegeInfo()) && Objects.equals(this.grantee, grantInfo.getIdentity()) && Objects.equals(this.schemaTableName, grantInfo.getSchemaTableName()) && Objects.equals(this.grantor, grantInfo.getGrantor()) && Objects.equals(this.withHierarchy, grantInfo.getWithHierarchy());
    }
}

