/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.client;

import com.facebook.presto.jdbc.internal.airlift.units.Duration;
import com.facebook.presto.jdbc.internal.guava.base.MoreObjects;
import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableMap;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableSet;
import com.facebook.presto.jdbc.internal.spi.type.TimeZoneKey;
import java.net.URI;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ClientSession {
    private final URI server;
    private final String user;
    private final String source;
    private final Set<String> clientTags;
    private final String clientInfo;
    private final String catalog;
    private final String schema;
    private final TimeZoneKey timeZone;
    private final Locale locale;
    private final Map<String, String> properties;
    private final Map<String, String> preparedStatements;
    private final String transactionId;
    private final boolean debug;
    private final Duration clientRequestTimeout;

    public static ClientSession withCatalogAndSchema(ClientSession session, String catalog, String schema) {
        return new ClientSession(session.getServer(), session.getUser(), session.getSource(), session.getClientTags(), session.getClientInfo(), catalog, schema, session.getTimeZone().getId(), session.getLocale(), session.getProperties(), session.getPreparedStatements(), session.getTransactionId(), session.isDebug(), session.getClientRequestTimeout());
    }

    public static ClientSession withProperties(ClientSession session, Map<String, String> properties) {
        return new ClientSession(session.getServer(), session.getUser(), session.getSource(), session.getClientTags(), session.getClientInfo(), session.getCatalog(), session.getSchema(), session.getTimeZone().getId(), session.getLocale(), properties, session.getPreparedStatements(), session.getTransactionId(), session.isDebug(), session.getClientRequestTimeout());
    }

    public static ClientSession withPreparedStatements(ClientSession session, Map<String, String> preparedStatements) {
        return new ClientSession(session.getServer(), session.getUser(), session.getSource(), session.getClientTags(), session.getClientInfo(), session.getCatalog(), session.getSchema(), session.getTimeZone().getId(), session.getLocale(), session.getProperties(), preparedStatements, session.getTransactionId(), session.isDebug(), session.getClientRequestTimeout());
    }

    public static ClientSession withTransactionId(ClientSession session, String transactionId) {
        return new ClientSession(session.getServer(), session.getUser(), session.getSource(), session.getClientTags(), session.getClientInfo(), session.getCatalog(), session.getSchema(), session.getTimeZone().getId(), session.getLocale(), session.getProperties(), session.getPreparedStatements(), transactionId, session.isDebug(), session.getClientRequestTimeout());
    }

    public static ClientSession stripTransactionId(ClientSession session) {
        return new ClientSession(session.getServer(), session.getUser(), session.getSource(), session.getClientTags(), session.getClientInfo(), session.getCatalog(), session.getSchema(), session.getTimeZone().getId(), session.getLocale(), session.getProperties(), session.getPreparedStatements(), null, session.isDebug(), session.getClientRequestTimeout());
    }

    public ClientSession(URI server, String user, String source, Set<String> clientTags, String clientInfo, String catalog, String schema, String timeZoneId, Locale locale, Map<String, String> properties, Map<String, String> preparedStatements, String transactionId, boolean debug, Duration clientRequestTimeout) {
        this.server = Objects.requireNonNull(server, "server is null");
        this.user = user;
        this.source = source;
        this.clientTags = ImmutableSet.copyOf((Collection)Objects.requireNonNull(clientTags, "clientTags is null"));
        this.clientInfo = clientInfo;
        this.catalog = catalog;
        this.schema = schema;
        this.locale = locale;
        this.timeZone = TimeZoneKey.getTimeZoneKey(timeZoneId);
        this.transactionId = transactionId;
        this.debug = debug;
        this.properties = ImmutableMap.copyOf(Objects.requireNonNull(properties, "properties is null"));
        this.preparedStatements = ImmutableMap.copyOf(Objects.requireNonNull(preparedStatements, "preparedStatements is null"));
        this.clientRequestTimeout = clientRequestTimeout;
        for (String clientTag : clientTags) {
            Preconditions.checkArgument(!clientTag.contains(","), "client tag cannot contain ','");
        }
        CharsetEncoder charsetEncoder = StandardCharsets.US_ASCII.newEncoder();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            Preconditions.checkArgument(!entry.getKey().isEmpty(), "Session property name is empty");
            Preconditions.checkArgument(entry.getKey().indexOf(61) < 0, "Session property name must not contain '=': %s", (Object)entry.getKey());
            Preconditions.checkArgument(charsetEncoder.canEncode(entry.getKey()), "Session property name is not US_ASCII: %s", (Object)entry.getKey());
            Preconditions.checkArgument(charsetEncoder.canEncode(entry.getValue()), "Session property value is not US_ASCII: %s", (Object)entry.getValue());
        }
    }

    public URI getServer() {
        return this.server;
    }

    public String getUser() {
        return this.user;
    }

    public String getSource() {
        return this.source;
    }

    public Set<String> getClientTags() {
        return this.clientTags;
    }

    public String getClientInfo() {
        return this.clientInfo;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public TimeZoneKey getTimeZone() {
        return this.timeZone;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<String, String> getPreparedStatements() {
        return this.preparedStatements;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public Duration getClientRequestTimeout() {
        return this.clientRequestTimeout;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("server", this.server).add("user", this.user).add("clientTags", this.clientTags).add("clientInfo", this.clientInfo).add("catalog", this.catalog).add("schema", this.schema).add("timeZone", this.timeZone).add("locale", this.locale).add("properties", this.properties).add("transactionId", this.transactionId).add("debug", this.debug).toString();
    }
}

