/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.spi.ConnectorSplit;
import com.facebook.presto.jdbc.internal.spi.connector.ConnectorPartitionHandle;
import com.facebook.presto.jdbc.internal.spi.connector.NotPartitionedPartitionHandle;
import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public interface ConnectorSplitSource
extends Closeable {
    @Deprecated
    default public CompletableFuture<List<ConnectorSplit>> getNextBatch(int maxSize) {
        throw new UnsupportedOperationException("deprecated");
    }

    default public CompletableFuture<ConnectorSplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, int maxSize) {
        if (partitionHandle != NotPartitionedPartitionHandle.NOT_PARTITIONED) {
            throw new UnsupportedOperationException();
        }
        return this.getNextBatch(maxSize).thenApply(splits -> new ConnectorSplitBatch((List<ConnectorSplit>)splits, this.isFinished()));
    }

    @Override
    public void close();

    public boolean isFinished();

    public static class ConnectorSplitBatch {
        private final List<ConnectorSplit> splits;
        private final boolean noMoreSplits;

        public ConnectorSplitBatch(List<ConnectorSplit> splits, boolean noMoreSplits) {
            this.splits = Objects.requireNonNull(splits, "splits is null");
            this.noMoreSplits = noMoreSplits;
        }

        public List<ConnectorSplit> getSplits() {
            return this.splits;
        }

        public boolean isNoMoreSplits() {
            return this.noMoreSplits;
        }
    }
}

