/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.spi.block.ArrayBlock;
import com.facebook.presto.jdbc.internal.spi.block.ArrayBlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.BlockUtil;
import com.facebook.presto.jdbc.internal.spi.block.IntArrayList;

public abstract class AbstractArrayBlock
implements Block {
    protected abstract Block getValues();

    protected abstract int[] getOffsets();

    protected abstract int getOffsetBase();

    protected abstract boolean[] getValueIsNull();

    int getOffset(int position) {
        return this.getOffsets()[position + this.getOffsetBase()];
    }

    @Override
    public BlockEncoding getEncoding() {
        return new ArrayBlockEncoding(this.getValues().getEncoding());
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkValidPositionsArray(positions, offset, length);
        int[] newOffsets = new int[length + 1];
        boolean[] newValueIsNull = new boolean[length];
        IntArrayList valuesPositions = new IntArrayList();
        int newPosition = 0;
        for (int i = offset; i < offset + length; ++i) {
            int position = positions[i];
            if (this.isNull(position)) {
                newValueIsNull[newPosition] = true;
                newOffsets[newPosition + 1] = newOffsets[newPosition];
            } else {
                int valuesStartOffset = this.getOffset(position);
                int valuesEndOffset = this.getOffset(position + 1);
                int valuesLength = valuesEndOffset - valuesStartOffset;
                newOffsets[newPosition + 1] = newOffsets[newPosition] + valuesLength;
                for (int elementIndex = valuesStartOffset; elementIndex < valuesEndOffset; ++elementIndex) {
                    valuesPositions.add(elementIndex);
                }
            }
            ++newPosition;
        }
        Block newValues = this.getValues().copyPositions(valuesPositions.elements(), 0, valuesPositions.size());
        return new ArrayBlock(length, newValueIsNull, newOffsets, newValues);
    }

    @Override
    public Block getRegion(int position, int length) {
        int positionCount = this.getPositionCount();
        if (position < 0 || length < 0 || position + length > positionCount) {
            throw new IndexOutOfBoundsException(String.format("Invalid position range [%s, %s) in block with %s positions", position, position + length, positionCount));
        }
        if (position == 0 && length == positionCount) {
            return this;
        }
        return new ArrayBlock(position + this.getOffsetBase(), length, this.getValueIsNull(), this.getOffsets(), this.getValues());
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        int positionCount = this.getPositionCount();
        if (position < 0 || length < 0 || position + length > positionCount) {
            throw new IndexOutOfBoundsException(String.format("Invalid position range [%s, %s) in block with %s positions", position, position + length, positionCount));
        }
        int valueStart = this.getOffsets()[this.getOffsetBase() + position];
        int valueEnd = this.getOffsets()[this.getOffsetBase() + position + length];
        return this.getValues().getRegionSizeInBytes(valueStart, valueEnd - valueStart) + 5L * (long)length;
    }

    @Override
    public Block copyRegion(int position, int length) {
        int positionCount = this.getPositionCount();
        if (position < 0 || length < 0 || position + length > positionCount) {
            throw new IndexOutOfBoundsException(String.format("Invalid position range [%s, %s) in block with %s positions", position, position + length, positionCount));
        }
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + length);
        Block newValues = this.getValues().copyRegion(startValueOffset, endValueOffset - startValueOffset);
        int[] newOffsets = BlockUtil.compactOffsets(this.getOffsets(), position + this.getOffsetBase(), length);
        boolean[] newValueIsNull = BlockUtil.compactArray(this.getValueIsNull(), position + this.getOffsetBase(), length);
        if (newValues == this.getValues() && newOffsets == this.getOffsets() && newValueIsNull == this.getValueIsNull()) {
            return this;
        }
        return new ArrayBlock(length, newValueIsNull, newOffsets, newValues);
    }

    @Override
    public <T> T getObject(int position, Class<T> clazz) {
        if (clazz != Block.class) {
            throw new IllegalArgumentException("clazz must be Block.class");
        }
        this.checkReadablePosition(position);
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + 1);
        return clazz.cast(this.getValues().getRegion(startValueOffset, endValueOffset - startValueOffset));
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        BlockBuilder entryBuilder = blockBuilder.beginBlockEntry();
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + 1);
        for (int i = startValueOffset; i < endValueOffset; ++i) {
            if (this.getValues().isNull(i)) {
                entryBuilder.appendNull();
                continue;
            }
            this.getValues().writePositionTo(i, entryBuilder);
            entryBuilder.closeEntry();
        }
    }

    @Override
    public Block getSingleValueBlock(int position) {
        this.checkReadablePosition(position);
        int startValueOffset = this.getOffset(position);
        int valueLength = this.getOffset(position + 1) - startValueOffset;
        Block newValues = this.getValues().copyRegion(startValueOffset, valueLength);
        return new ArrayBlock(1, new boolean[]{this.isNull(position)}, new int[]{0, valueLength}, newValues);
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.getValueIsNull()[position + this.getOffsetBase()];
    }

    public <T> T apply(ArrayBlockFunction<T> function, int position) {
        this.checkReadablePosition(position);
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + 1);
        return function.apply(this.getValues(), startValueOffset, endValueOffset - startValueOffset);
    }

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }

    public static interface ArrayBlockFunction<T> {
        public T apply(Block var1, int var2, int var3);
    }
}

