/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SliceInput;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.spi.block.AbstractRowBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncodingFactory;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncodingSerde;
import com.facebook.presto.jdbc.internal.spi.block.EncoderUtil;
import com.facebook.presto.jdbc.internal.spi.block.RowBlock;
import com.facebook.presto.jdbc.internal.spi.type.TypeManager;
import java.util.Objects;

public class RowBlockEncoding
implements BlockEncoding {
    public static final BlockEncodingFactory<RowBlockEncoding> FACTORY = new RowBlockEncodingFactory();
    private static final String NAME = "ROW";
    private final BlockEncoding[] fieldBlockEncodings;

    public RowBlockEncoding(BlockEncoding[] fieldBlockEncodings) {
        this.fieldBlockEncodings = Objects.requireNonNull(fieldBlockEncodings, "fieldBlockEncodings is null");
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(SliceOutput sliceOutput, Block block) {
        AbstractRowBlock rowBlock = (AbstractRowBlock)block;
        if (rowBlock.numFields != this.fieldBlockEncodings.length) {
            throw new IllegalArgumentException("argument block differs in length (" + rowBlock.numFields + ") with this encoding (" + this.fieldBlockEncodings.length + ")");
        }
        int positionCount = rowBlock.getPositionCount();
        int offsetBase = rowBlock.getOffsetBase();
        int[] fieldBlockOffsets = rowBlock.getFieldBlockOffsets();
        int startFieldBlockOffset = fieldBlockOffsets[offsetBase];
        int endFieldBlockOffset = fieldBlockOffsets[offsetBase + positionCount];
        for (int i = 0; i < this.fieldBlockEncodings.length; ++i) {
            this.fieldBlockEncodings[i].writeBlock(sliceOutput, rowBlock.getFieldBlocks()[i].getRegion(startFieldBlockOffset, endFieldBlockOffset - startFieldBlockOffset));
        }
        sliceOutput.appendInt(positionCount);
        for (int position = 0; position < positionCount + 1; ++position) {
            sliceOutput.writeInt(fieldBlockOffsets[offsetBase + position] - startFieldBlockOffset);
        }
        EncoderUtil.encodeNullsAsBits(sliceOutput, block);
    }

    @Override
    public Block readBlock(SliceInput sliceInput) {
        Block[] fieldBlocks = new Block[this.fieldBlockEncodings.length];
        for (int i = 0; i < this.fieldBlockEncodings.length; ++i) {
            fieldBlocks[i] = this.fieldBlockEncodings[i].readBlock(sliceInput);
        }
        int positionCount = sliceInput.readInt();
        int[] fieldBlockOffsets = new int[positionCount + 1];
        sliceInput.readBytes(Slices.wrappedIntArray(fieldBlockOffsets));
        boolean[] rowIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount);
        return new RowBlock(0, positionCount, rowIsNull, fieldBlockOffsets, fieldBlocks);
    }

    @Override
    public BlockEncodingFactory getFactory() {
        return FACTORY;
    }

    public static class RowBlockEncodingFactory
    implements BlockEncodingFactory<RowBlockEncoding> {
        @Override
        public String getName() {
            return RowBlockEncoding.NAME;
        }

        @Override
        public RowBlockEncoding readEncoding(TypeManager typeManager, BlockEncodingSerde serde, SliceInput input) {
            int numFields = input.readInt();
            BlockEncoding[] fieldBlockEncodings = new BlockEncoding[numFields];
            for (int i = 0; i < numFields; ++i) {
                fieldBlockEncodings[i] = serde.readBlockEncoding(input);
            }
            return new RowBlockEncoding(fieldBlockEncodings);
        }

        @Override
        public void writeEncoding(BlockEncodingSerde serde, SliceOutput output, RowBlockEncoding blockEncoding) {
            output.appendInt(blockEncoding.fieldBlockEncodings.length);
            for (BlockEncoding fieldBlockEncoding : blockEncoding.fieldBlockEncodings) {
                serde.writeBlockEncoding(output, fieldBlockEncoding);
            }
        }
    }
}

