/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.DynamicSliceOutput;
import com.facebook.presto.jdbc.internal.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.block.AbstractVariableWidthBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.spi.block.BlockUtil;
import com.facebook.presto.jdbc.internal.spi.block.VariableWidthBlock;
import java.util.Arrays;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;

public class VariableWidthBlockBuilder
extends AbstractVariableWidthBlock
implements BlockBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(VariableWidthBlockBuilder.class).instanceSize();
    private BlockBuilderStatus blockBuilderStatus;
    private boolean initialized;
    private int initialEntryCount;
    private int initialSliceOutputSize;
    private SliceOutput sliceOutput = new DynamicSliceOutput(0);
    private boolean[] valueIsNull = new boolean[0];
    private int[] offsets = new int[1];
    private int positions;
    private int currentEntrySize;
    private long arraysRetainedSizeInBytes;

    public VariableWidthBlockBuilder(@Nullable BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytes) {
        this.blockBuilderStatus = blockBuilderStatus;
        this.initialEntryCount = expectedEntries;
        this.initialSliceOutputSize = Math.min(expectedBytes, 0x7FFFFFF7);
        this.updateArraysDataSize();
    }

    @Override
    protected int getPositionOffset(int position) {
        if (position >= this.positions) {
            throw new IllegalArgumentException("position " + position + " must be less than position count " + this.positions);
        }
        return this.getOffset(position);
    }

    @Override
    public int getSliceLength(int position) {
        if (position >= this.positions) {
            throw new IllegalArgumentException("position " + position + " must be less than position count " + this.positions);
        }
        return this.getOffset(position + 1) - this.getOffset(position);
    }

    @Override
    protected Slice getRawSlice(int position) {
        return this.sliceOutput.getUnderlyingSlice();
    }

    @Override
    public int getPositionCount() {
        return this.positions;
    }

    @Override
    public long getSizeInBytes() {
        long arraysSizeInBytes = 5L * (long)this.positions;
        return (long)this.sliceOutput.size() + arraysSizeInBytes;
    }

    @Override
    public long getRegionSizeInBytes(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " length " + length + " in block with " + positionCount + " positions");
        }
        long arraysSizeInBytes = 5L * (long)length;
        return (long)(this.getOffset(positionOffset + length) - this.getOffset(positionOffset)) + arraysSizeInBytes;
    }

    @Override
    public long getRetainedSizeInBytes() {
        long size = (long)INSTANCE_SIZE + this.sliceOutput.getRetainedSize() + this.arraysRetainedSizeInBytes;
        if (this.blockBuilderStatus != null) {
            size += (long)BlockBuilderStatus.INSTANCE_SIZE;
        }
        return size;
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.sliceOutput, this.sliceOutput.getRetainedSize());
        consumer.accept(this.offsets, SizeOf.sizeOf(this.offsets));
        consumer.accept(this.valueIsNull, SizeOf.sizeOf(this.valueIsNull));
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkValidPositionsArray(positions, offset, length);
        int finalLength = Arrays.stream(positions, offset, offset + length).map(this::getSliceLength).sum();
        SliceOutput newSlice = Slices.allocate(finalLength).getOutput();
        int[] newOffsets = new int[length + 1];
        boolean[] newValueIsNull = new boolean[length];
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            if (this.isEntryNull(position)) {
                newValueIsNull[i] = true;
            } else {
                newSlice.appendBytes(this.sliceOutput.getUnderlyingSlice().getBytes(this.getPositionOffset(position), this.getSliceLength(position)));
            }
            newOffsets[i + 1] = newSlice.size();
        }
        return new VariableWidthBlock(length, newSlice.slice(), newOffsets, newValueIsNull);
    }

    @Override
    public BlockBuilder writeByte(int value) {
        if (!this.initialized) {
            this.initializeCapacity();
        }
        this.sliceOutput.writeByte(value);
        ++this.currentEntrySize;
        return this;
    }

    @Override
    public BlockBuilder writeShort(int value) {
        if (!this.initialized) {
            this.initializeCapacity();
        }
        this.sliceOutput.writeShort(value);
        this.currentEntrySize += 2;
        return this;
    }

    @Override
    public BlockBuilder writeInt(int value) {
        if (!this.initialized) {
            this.initializeCapacity();
        }
        this.sliceOutput.writeInt(value);
        this.currentEntrySize += 4;
        return this;
    }

    @Override
    public BlockBuilder writeLong(long value) {
        if (!this.initialized) {
            this.initializeCapacity();
        }
        this.sliceOutput.writeLong(value);
        this.currentEntrySize += 8;
        return this;
    }

    @Override
    public BlockBuilder writeBytes(Slice source, int sourceIndex, int length) {
        if (!this.initialized) {
            this.initializeCapacity();
        }
        this.sliceOutput.writeBytes(source, sourceIndex, length);
        this.currentEntrySize += length;
        return this;
    }

    @Override
    public BlockBuilder closeEntry() {
        this.entryAdded(this.currentEntrySize, false);
        this.currentEntrySize = 0;
        return this;
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.currentEntrySize > 0) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        this.entryAdded(0, true);
        return this;
    }

    private void entryAdded(int bytesWritten, boolean isNull) {
        if (!this.initialized) {
            this.initializeCapacity();
        }
        if (this.valueIsNull.length <= this.positions) {
            this.growCapacity();
        }
        this.valueIsNull[this.positions] = isNull;
        this.offsets[this.positions + 1] = this.sliceOutput.size();
        ++this.positions;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(5 + bytesWritten);
        }
    }

    private void growCapacity() {
        int newSize = BlockUtil.calculateNewArraySize(this.valueIsNull.length);
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.offsets = Arrays.copyOf(this.offsets, newSize + 1);
        this.updateArraysDataSize();
    }

    private void initializeCapacity() {
        if (this.positions != 0 || this.currentEntrySize != 0) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " was used before initialization");
        }
        this.initialized = true;
        this.valueIsNull = new boolean[this.initialEntryCount];
        this.offsets = new int[this.initialEntryCount + 1];
        this.sliceOutput = new DynamicSliceOutput(this.initialSliceOutputSize);
        this.updateArraysDataSize();
    }

    private void updateArraysDataSize() {
        this.arraysRetainedSizeInBytes = SizeOf.sizeOf(this.valueIsNull) + SizeOf.sizeOf(this.offsets);
    }

    @Override
    protected boolean isEntryNull(int position) {
        return this.valueIsNull[position];
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + positionCount + " positions");
        }
        return new VariableWidthBlock(positionOffset, length, this.sliceOutput.slice(), this.offsets, this.valueIsNull);
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + positionCount + " positions");
        }
        int[] newOffsets = BlockUtil.compactOffsets(this.offsets, positionOffset, length);
        boolean[] newValueIsNull = BlockUtil.compactArray(this.valueIsNull, positionOffset, length);
        Slice slice = BlockUtil.compactSlice(this.sliceOutput.getUnderlyingSlice(), this.offsets[positionOffset], newOffsets[length]);
        return new VariableWidthBlock(length, slice, newOffsets, newValueIsNull);
    }

    @Override
    public Block build() {
        if (this.currentEntrySize > 0) {
            throw new IllegalStateException("Current entry must be closed before the block can be built");
        }
        return new VariableWidthBlock(this.positions, this.sliceOutput.slice(), this.offsets, this.valueIsNull);
    }

    @Override
    public BlockBuilder newBlockBuilderLike(BlockBuilderStatus blockBuilderStatus) {
        int currentSizeInBytes = this.positions == 0 ? this.positions : this.getOffset(this.positions) - this.getOffset(0);
        return new VariableWidthBlockBuilder(blockBuilderStatus, BlockUtil.calculateBlockResetSize(this.positions), BlockUtil.calculateBlockResetBytes(currentSizeInBytes));
    }

    private int getOffset(int position) {
        return this.offsets[position];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VariableWidthBlockBuilder{");
        sb.append("positionCount=").append(this.positions);
        sb.append(", size=").append(this.sliceOutput.size());
        sb.append('}');
        return sb.toString();
    }
}

