/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.BlockUtil;
import com.facebook.presto.jdbc.internal.spi.block.IntArrayList;
import com.facebook.presto.jdbc.internal.spi.block.RowBlock;
import com.facebook.presto.jdbc.internal.spi.block.RowBlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.SingleRowBlock;

public abstract class AbstractRowBlock
implements Block {
    protected final int numFields;

    protected abstract Block[] getFieldBlocks();

    protected abstract int[] getFieldBlockOffsets();

    protected abstract int getOffsetBase();

    protected abstract boolean[] getRowIsNull();

    protected int getFieldBlockOffset(int position) {
        return this.getFieldBlockOffsets()[position + this.getOffsetBase()];
    }

    protected AbstractRowBlock(int numFields) {
        if (numFields <= 0) {
            throw new IllegalArgumentException("Number of fields in RowBlock must be positive");
        }
        this.numFields = numFields;
    }

    @Override
    public RowBlockEncoding getEncoding() {
        BlockEncoding[] fieldBlockEncodings = new BlockEncoding[this.numFields];
        for (int i = 0; i < this.numFields; ++i) {
            fieldBlockEncodings[i] = this.getFieldBlocks()[i].getEncoding();
        }
        return new RowBlockEncoding(fieldBlockEncodings);
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        int[] newOffsets = new int[length + 1];
        boolean[] newRowIsNull = new boolean[length];
        IntArrayList fieldBlockPositions = new IntArrayList(length);
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            if (this.isNull(position)) {
                newRowIsNull[i] = true;
                newOffsets[i + 1] = newOffsets[i];
                continue;
            }
            newOffsets[i + 1] = newOffsets[i] + 1;
            fieldBlockPositions.add(this.getFieldBlockOffset(position));
        }
        Block[] newBlocks = new Block[this.numFields];
        for (int i = 0; i < this.numFields; ++i) {
            newBlocks[i] = this.getFieldBlocks()[i].copyPositions(fieldBlockPositions.elements(), 0, fieldBlockPositions.size());
        }
        return new RowBlock(0, length, newRowIsNull, newOffsets, newBlocks);
    }

    @Override
    public Block getRegion(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        if (position == 0 && length == positionCount) {
            return this;
        }
        return new RowBlock(position + this.getOffsetBase(), length, this.getRowIsNull(), this.getFieldBlockOffsets(), this.getFieldBlocks());
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        int startFieldBlockOffset = this.getFieldBlockOffset(position);
        int endFieldBlockOffset = this.getFieldBlockOffset(position + length);
        int fieldBlockLength = endFieldBlockOffset - startFieldBlockOffset;
        long regionSizeInBytes = 5L * (long)length;
        for (int i = 0; i < this.numFields; ++i) {
            regionSizeInBytes += this.getFieldBlocks()[i].getRegionSizeInBytes(startFieldBlockOffset, fieldBlockLength);
        }
        return regionSizeInBytes;
    }

    @Override
    public Block copyRegion(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        int startFieldBlockOffset = this.getFieldBlockOffset(position);
        int endFieldBlockOffset = this.getFieldBlockOffset(position + length);
        int fieldBlockLength = endFieldBlockOffset - startFieldBlockOffset;
        Object[] newBlocks = new Block[this.numFields];
        for (int i = 0; i < this.numFields; ++i) {
            newBlocks[i] = this.getFieldBlocks()[i].copyRegion(startFieldBlockOffset, fieldBlockLength);
        }
        int[] newOffsets = BlockUtil.compactOffsets(this.getFieldBlockOffsets(), position + this.getOffsetBase(), length);
        boolean[] newRowIsNull = BlockUtil.compactArray(this.getRowIsNull(), position + this.getOffsetBase(), length);
        if (BlockUtil.arraySame(newBlocks, this.getFieldBlocks()) && newOffsets == this.getFieldBlockOffsets() && newRowIsNull == this.getRowIsNull()) {
            return this;
        }
        return new RowBlock(0, length, newRowIsNull, newOffsets, (Block[])newBlocks);
    }

    @Override
    public <T> T getObject(int position, Class<T> clazz) {
        if (clazz != Block.class) {
            throw new IllegalArgumentException("clazz must be Block.class");
        }
        this.checkReadablePosition(position);
        return clazz.cast(new SingleRowBlock(this.getFieldBlockOffset(position), this.getFieldBlocks()));
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        BlockBuilder entryBuilder = blockBuilder.beginBlockEntry();
        int fieldBlockOffset = this.getFieldBlockOffset(position);
        for (int i = 0; i < this.numFields; ++i) {
            if (this.getFieldBlocks()[i].isNull(fieldBlockOffset)) {
                entryBuilder.appendNull();
                continue;
            }
            this.getFieldBlocks()[i].writePositionTo(fieldBlockOffset, entryBuilder);
            entryBuilder.closeEntry();
        }
    }

    @Override
    public Block getSingleValueBlock(int position) {
        this.checkReadablePosition(position);
        int startFieldBlockOffset = this.getFieldBlockOffset(position);
        int endFieldBlockOffset = this.getFieldBlockOffset(position + 1);
        int fieldBlockLength = endFieldBlockOffset - startFieldBlockOffset;
        Block[] newBlocks = new Block[this.numFields];
        for (int i = 0; i < this.numFields; ++i) {
            newBlocks[i] = this.getFieldBlocks()[i].copyRegion(startFieldBlockOffset, fieldBlockLength);
        }
        boolean[] newRowIsNull = new boolean[]{this.isNull(position)};
        int[] newOffsets = new int[]{0, fieldBlockLength};
        return new RowBlock(0, 1, newRowIsNull, newOffsets, newBlocks);
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.getRowIsNull()[position + this.getOffsetBase()];
    }

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }
}

