/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.security.pem;

import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Base64;

public final class PemWriter {
    private PemWriter() {
    }

    public static String writePrivateKey(PrivateKey privateKey) {
        return PemWriter.encodePem("PRIVATE KEY", privateKey.getEncoded());
    }

    public static String writeCertificate(X509Certificate certificate) throws CertificateEncodingException {
        return PemWriter.encodePem("CERTIFICATE", certificate.getEncoded());
    }

    private static String encodePem(String type, byte[] encoded) {
        return "-----BEGIN " + type + "-----\n" + Base64.getMimeEncoder(64, new byte[]{10}).encodeToString(encoded) + '\n' + "-----END " + type + "-----\n";
    }
}

