/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.slice;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.airlift.slice.Slices;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public class Murmur3Hash128 {
    private static final long C1 = -8663945395140668459L;
    private static final long C2 = 5545529020109919103L;
    private static final long DEFAULT_SEED = 0L;

    public static Slice hash(Slice data) {
        return Murmur3Hash128.hash(data, 0, data.length());
    }

    public static Slice hash(Slice data, int offset, int length) {
        return Murmur3Hash128.hash(0L, data, offset, length);
    }

    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"})
    public static Slice hash(long seed, Slice data, int offset, int length) {
        long k2;
        long k1;
        int fastLimit = offset + length - 16 + 1;
        long h1 = seed;
        long h2 = seed;
        int current = offset;
        while (current < fastLimit) {
            k1 = data.getLong(current);
            k2 = data.getLong(current += 8);
            current += 8;
            k1 *= -8663945395140668459L;
            k1 = Long.rotateLeft(k1, 31);
            h1 ^= (k1 *= 5545529020109919103L);
            h1 = Long.rotateLeft(h1, 27);
            h1 += h2;
            h1 = h1 * 5L + 1390208809L;
            k2 *= 5545529020109919103L;
            k2 = Long.rotateLeft(k2, 33);
            h2 ^= (k2 *= -8663945395140668459L);
            h2 = Long.rotateLeft(h2, 31);
            h2 += h1;
            h2 = h2 * 5L + 944331445L;
        }
        k1 = 0L;
        k2 = 0L;
        switch (length & 0xF) {
            case 15: {
                k2 ^= (long)data.getUnsignedByte(current + 14) << 48;
            }
            case 14: {
                k2 ^= (long)data.getUnsignedByte(current + 13) << 40;
            }
            case 13: {
                k2 ^= (long)data.getUnsignedByte(current + 12) << 32;
            }
            case 12: {
                k2 ^= (long)data.getUnsignedByte(current + 11) << 24;
            }
            case 11: {
                k2 ^= (long)data.getUnsignedByte(current + 10) << 16;
            }
            case 10: {
                k2 ^= (long)data.getUnsignedByte(current + 9) << 8;
            }
            case 9: {
                k2 ^= (long)data.getUnsignedByte(current + 8) << 0;
                k2 *= 5545529020109919103L;
                k2 = Long.rotateLeft(k2, 33);
                h2 ^= (k2 *= -8663945395140668459L);
            }
            case 8: {
                k1 ^= (long)data.getUnsignedByte(current + 7) << 56;
            }
            case 7: {
                k1 ^= (long)data.getUnsignedByte(current + 6) << 48;
            }
            case 6: {
                k1 ^= (long)data.getUnsignedByte(current + 5) << 40;
            }
            case 5: {
                k1 ^= (long)data.getUnsignedByte(current + 4) << 32;
            }
            case 4: {
                k1 ^= (long)data.getUnsignedByte(current + 3) << 24;
            }
            case 3: {
                k1 ^= (long)data.getUnsignedByte(current + 2) << 16;
            }
            case 2: {
                k1 ^= (long)data.getUnsignedByte(current + 1) << 8;
            }
            case 1: {
                k1 ^= (long)data.getUnsignedByte(current + 0) << 0;
                k1 *= -8663945395140668459L;
                k1 = Long.rotateLeft(k1, 31);
                h1 ^= (k1 *= 5545529020109919103L);
            }
        }
        h1 ^= (long)length;
        h1 += (h2 ^= (long)length);
        h2 += h1;
        h1 = Murmur3Hash128.mix64(h1);
        h2 = Murmur3Hash128.mix64(h2);
        h1 += h2;
        Slice result = Slices.allocate(16);
        result.setLong(0, h1);
        result.setLong(8, h2 += h1);
        return result;
    }

    public static long hash64(Slice data) {
        return Murmur3Hash128.hash64(data, 0, data.length());
    }

    public static long hash64(Slice data, int offset, int length) {
        return Murmur3Hash128.hash64(0L, data, offset, length);
    }

    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT", "SF_SWITCH_FALLTHROUGH"})
    public static long hash64(long seed, Slice data, int offset, int length) {
        long k2;
        long k1;
        int fastLimit = offset + length - 16 + 1;
        long h1 = seed;
        long h2 = seed;
        int current = offset;
        while (current < fastLimit) {
            k1 = data.getLong(current);
            k2 = data.getLong(current += 8);
            current += 8;
            k1 *= -8663945395140668459L;
            k1 = Long.rotateLeft(k1, 31);
            h1 ^= (k1 *= 5545529020109919103L);
            h1 = Long.rotateLeft(h1, 27);
            h1 += h2;
            h1 = h1 * 5L + 1390208809L;
            k2 *= 5545529020109919103L;
            k2 = Long.rotateLeft(k2, 33);
            h2 ^= (k2 *= -8663945395140668459L);
            h2 = Long.rotateLeft(h2, 31);
            h2 += h1;
            h2 = h2 * 5L + 944331445L;
        }
        k1 = 0L;
        k2 = 0L;
        switch (length & 0xF) {
            case 15: {
                k2 ^= (long)data.getUnsignedByte(current + 14) << 48;
            }
            case 14: {
                k2 ^= (long)data.getUnsignedByte(current + 13) << 40;
            }
            case 13: {
                k2 ^= (long)data.getUnsignedByte(current + 12) << 32;
            }
            case 12: {
                k2 ^= (long)data.getUnsignedByte(current + 11) << 24;
            }
            case 11: {
                k2 ^= (long)data.getUnsignedByte(current + 10) << 16;
            }
            case 10: {
                k2 ^= (long)data.getUnsignedByte(current + 9) << 8;
            }
            case 9: {
                k2 ^= (long)data.getUnsignedByte(current + 8) << 0;
                k2 *= 5545529020109919103L;
                k2 = Long.rotateLeft(k2, 33);
                h2 ^= (k2 *= -8663945395140668459L);
            }
            case 8: {
                k1 ^= (long)data.getUnsignedByte(current + 7) << 56;
            }
            case 7: {
                k1 ^= (long)data.getUnsignedByte(current + 6) << 48;
            }
            case 6: {
                k1 ^= (long)data.getUnsignedByte(current + 5) << 40;
            }
            case 5: {
                k1 ^= (long)data.getUnsignedByte(current + 4) << 32;
            }
            case 4: {
                k1 ^= (long)data.getUnsignedByte(current + 3) << 24;
            }
            case 3: {
                k1 ^= (long)data.getUnsignedByte(current + 2) << 16;
            }
            case 2: {
                k1 ^= (long)data.getUnsignedByte(current + 1) << 8;
            }
            case 1: {
                k1 ^= (long)data.getUnsignedByte(current + 0) << 0;
                k1 *= -8663945395140668459L;
                k1 = Long.rotateLeft(k1, 31);
                h1 ^= (k1 *= 5545529020109919103L);
            }
        }
        h1 ^= (long)length;
        h1 += (h2 ^= (long)length);
        h2 += h1;
        h1 = Murmur3Hash128.mix64(h1);
        h2 = Murmur3Hash128.mix64(h2);
        return h1 + h2;
    }

    public static long hash64(long value) {
        long h2 = 8L;
        long h1 = h2 + (h2 ^ Long.rotateLeft(value * -8663945395140668459L, 31) * 5545529020109919103L);
        return Murmur3Hash128.mix64(h1) + Murmur3Hash128.mix64(h1 + h2);
    }

    private static long mix64(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }
}

