/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;

public abstract class AbstractSingleRowBlock
implements Block {
    protected final int rowIndex;

    protected AbstractSingleRowBlock(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    protected abstract Block getFieldBlock(int var1);

    private void checkFieldIndex(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid: " + position);
        }
    }

    @Override
    public boolean isNull(int position) {
        this.checkFieldIndex(position);
        return this.getFieldBlock(position).isNull(this.rowIndex);
    }

    @Override
    public byte getByte(int position, int offset) {
        this.checkFieldIndex(position);
        return this.getFieldBlock(position).getByte(this.rowIndex, offset);
    }

    @Override
    public short getShort(int position, int offset) {
        this.checkFieldIndex(position);
        return this.getFieldBlock(position).getShort(this.rowIndex, offset);
    }

    @Override
    public int getInt(int position, int offset) {
        this.checkFieldIndex(position);
        return this.getFieldBlock(position).getInt(this.rowIndex, offset);
    }

    @Override
    public long getLong(int position, int offset) {
        this.checkFieldIndex(position);
        return this.getFieldBlock(position).getLong(this.rowIndex, offset);
    }

    @Override
    public Slice getSlice(int position, int offset, int length) {
        this.checkFieldIndex(position);
        return this.getFieldBlock(position).getSlice(this.rowIndex, offset, length);
    }

    @Override
    public int getSliceLength(int position) {
        this.checkFieldIndex(position);
        return this.getFieldBlock(position).getSliceLength(this.rowIndex);
    }

    @Override
    public int compareTo(int position, int offset, int length, Block otherBlock, int otherPosition, int otherOffset, int otherLength) {
        this.checkFieldIndex(position);
        return this.getFieldBlock(position).compareTo(this.rowIndex, offset, length, otherBlock, otherPosition, otherOffset, otherLength);
    }

    @Override
    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        this.checkFieldIndex(position);
        return this.getFieldBlock(position).bytesEqual(this.rowIndex, offset, otherSlice, otherOffset, length);
    }

    @Override
    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        this.checkFieldIndex(position);
        return this.getFieldBlock(position).bytesCompare(this.rowIndex, offset, length, otherSlice, otherOffset, otherLength);
    }

    @Override
    public void writeBytesTo(int position, int offset, int length, BlockBuilder blockBuilder) {
        this.checkFieldIndex(position);
        this.getFieldBlock(position).writeBytesTo(this.rowIndex, offset, length, blockBuilder);
    }

    @Override
    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        this.checkFieldIndex(position);
        return this.getFieldBlock(position).equals(this.rowIndex, offset, otherBlock, otherPosition, otherOffset, length);
    }

    @Override
    public long hash(int position, int offset, int length) {
        this.checkFieldIndex(position);
        return this.getFieldBlock(position).hash(this.rowIndex, offset, length);
    }

    @Override
    public <T> T getObject(int position, Class<T> clazz) {
        this.checkFieldIndex(position);
        return this.getFieldBlock(position).getObject(this.rowIndex, clazz);
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.checkFieldIndex(position);
        this.getFieldBlock(position).writePositionTo(this.rowIndex, blockBuilder);
    }

    @Override
    public Block getSingleValueBlock(int position) {
        this.checkFieldIndex(position);
        return this.getFieldBlock(position).getSingleValueBlock(this.rowIndex);
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block copyRegion(int position, int length) {
        throw new UnsupportedOperationException();
    }
}

