/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.statistics;

import com.facebook.presto.jdbc.internal.spi.ColumnHandle;
import com.facebook.presto.jdbc.internal.spi.statistics.ColumnStatistics;
import com.facebook.presto.jdbc.internal.spi.statistics.Estimate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class TableStatistics {
    public static final TableStatistics EMPTY_STATISTICS = TableStatistics.builder().build();
    private final Estimate rowCount;
    private final Map<ColumnHandle, ColumnStatistics> columnStatistics;

    public TableStatistics(Estimate rowCount, Map<ColumnHandle, ColumnStatistics> columnStatistics) {
        this.rowCount = Objects.requireNonNull(rowCount, "rowCount can not be null");
        this.columnStatistics = Collections.unmodifiableMap(Objects.requireNonNull(columnStatistics, "columnStatistics can not be null"));
    }

    public Estimate getRowCount() {
        return this.rowCount;
    }

    public Map<ColumnHandle, ColumnStatistics> getColumnStatistics() {
        return this.columnStatistics;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Estimate rowCount = Estimate.unknownValue();
        private Map<ColumnHandle, ColumnStatistics> columnStatisticsMap = new HashMap<ColumnHandle, ColumnStatistics>();

        public Builder setRowCount(Estimate rowCount) {
            this.rowCount = Objects.requireNonNull(rowCount, "rowCount can not be null");
            return this;
        }

        public Builder setColumnStatistics(ColumnHandle columnName, ColumnStatistics columnStatistics) {
            Objects.requireNonNull(columnName, "columnName can not be null");
            Objects.requireNonNull(columnStatistics, "columnStatistics can not be null");
            this.columnStatisticsMap.put(columnName, columnStatistics);
            return this;
        }

        public TableStatistics build() {
            return new TableStatistics(this.rowCount, this.columnStatisticsMap);
        }
    }
}

