/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc;

import com.facebook.presto.jdbc.AbstractConnectionProperty;
import com.facebook.presto.jdbc.ConnectionProperty;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableMap;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableSet;
import com.facebook.presto.jdbc.internal.guava.net.HostAndPort;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

final class ConnectionProperties {
    public static final ConnectionProperty<String> USER = new User();
    public static final ConnectionProperty<String> PASSWORD = new Password();
    public static final ConnectionProperty<HostAndPort> SOCKS_PROXY = new SocksProxy();
    public static final ConnectionProperty<HostAndPort> HTTP_PROXY = new HttpProxy();
    public static final ConnectionProperty<Boolean> SSL = new Ssl();
    public static final ConnectionProperty<String> SSL_KEY_STORE_PATH = new SslKeyStorePath();
    public static final ConnectionProperty<String> SSL_KEY_STORE_PASSWORD = new SslKeyStorePassword();
    public static final ConnectionProperty<String> SSL_TRUST_STORE_PATH = new SslTrustStorePath();
    public static final ConnectionProperty<String> SSL_TRUST_STORE_PASSWORD = new SslTrustStorePassword();
    public static final ConnectionProperty<String> KERBEROS_REMOTE_SERVICE_NAME = new KerberosRemoteServiceName();
    public static final ConnectionProperty<Boolean> KERBEROS_USE_CANONICAL_HOSTNAME = new KerberosUseCanonicalHostname();
    public static final ConnectionProperty<String> KERBEROS_PRINCIPAL = new KerberosPrincipal();
    public static final ConnectionProperty<File> KERBEROS_CONFIG_PATH = new KerberosConfigPath();
    public static final ConnectionProperty<File> KERBEROS_KEYTAB_PATH = new KerberosKeytabPath();
    public static final ConnectionProperty<File> KERBEROS_CREDENTIAL_CACHE_PATH = new KerberosCredentialCachePath();
    private static final Set<ConnectionProperty<?>> ALL_PROPERTIES = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(USER)).add(PASSWORD)).add(SOCKS_PROXY)).add(HTTP_PROXY)).add(SSL)).add(SSL_KEY_STORE_PATH)).add(SSL_KEY_STORE_PASSWORD)).add(SSL_TRUST_STORE_PATH)).add(SSL_TRUST_STORE_PASSWORD)).add(KERBEROS_REMOTE_SERVICE_NAME)).add(KERBEROS_USE_CANONICAL_HOSTNAME)).add(KERBEROS_PRINCIPAL)).add(KERBEROS_CONFIG_PATH)).add(KERBEROS_KEYTAB_PATH)).add(KERBEROS_CREDENTIAL_CACHE_PATH)).build();
    private static final Map<String, ConnectionProperty<?>> KEY_LOOKUP = Collections.unmodifiableMap(ALL_PROPERTIES.stream().collect(Collectors.toMap(ConnectionProperty::getKey, Function.identity())));
    private static final Map<String, String> DEFAULTS;

    private ConnectionProperties() {
    }

    public static ConnectionProperty<?> forKey(String propertiesKey) {
        return KEY_LOOKUP.get(propertiesKey);
    }

    public static Set<ConnectionProperty<?>> allProperties() {
        return ALL_PROPERTIES;
    }

    public static Map<String, String> getDefaults() {
        return DEFAULTS;
    }

    private static Predicate<Properties> isKerberosEnabled() {
        return AbstractConnectionProperty.checkedPredicate(properties -> KERBEROS_REMOTE_SERVICE_NAME.getValue((Properties)properties).isPresent());
    }

    static {
        ImmutableMap.Builder defaults = ImmutableMap.builder();
        for (ConnectionProperty<?> property : ALL_PROPERTIES) {
            property.getDefault().ifPresent(value -> defaults.put(property.getKey(), value));
        }
        DEFAULTS = defaults.build();
    }

    private static class KerberosCredentialCachePath
    extends AbstractConnectionProperty<File> {
        public KerberosCredentialCachePath() {
            super("KerberosCredentialCachePath", NOT_REQUIRED, ConnectionProperties.isKerberosEnabled(), FILE_CONVERTER);
        }
    }

    private static class KerberosKeytabPath
    extends AbstractConnectionProperty<File> {
        public KerberosKeytabPath() {
            super("KerberosKeytabPath", NOT_REQUIRED, ConnectionProperties.isKerberosEnabled(), FILE_CONVERTER);
        }
    }

    private static class KerberosConfigPath
    extends AbstractConnectionProperty<File> {
        public KerberosConfigPath() {
            super("KerberosConfigPath", NOT_REQUIRED, ConnectionProperties.isKerberosEnabled(), FILE_CONVERTER);
        }
    }

    private static class KerberosUseCanonicalHostname
    extends AbstractConnectionProperty<Boolean> {
        public KerberosUseCanonicalHostname() {
            super("KerberosUseCanonicalHostname", Optional.of("true"), ConnectionProperties.isKerberosEnabled(), ALLOWED, BOOLEAN_CONVERTER);
        }
    }

    private static class KerberosPrincipal
    extends AbstractConnectionProperty<String> {
        public KerberosPrincipal() {
            super("KerberosPrincipal", NOT_REQUIRED, ConnectionProperties.isKerberosEnabled(), STRING_CONVERTER);
        }
    }

    private static class KerberosRemoteServiceName
    extends AbstractConnectionProperty<String> {
        public KerberosRemoteServiceName() {
            super("KerberosRemoteServiceName", NOT_REQUIRED, ALLOWED, STRING_CONVERTER);
        }
    }

    private static class SslTrustStorePassword
    extends AbstractConnectionProperty<String> {
        private static final Predicate<Properties> IF_TRUST_STORE = SslTrustStorePassword.checkedPredicate(properties -> SSL_TRUST_STORE_PATH.getValue((Properties)properties).isPresent());

        public SslTrustStorePassword() {
            super("SSLTrustStorePassword", NOT_REQUIRED, IF_TRUST_STORE, STRING_CONVERTER);
        }
    }

    private static class SslTrustStorePath
    extends AbstractConnectionProperty<String> {
        private static final Predicate<Properties> IF_SSL_ENABLED = SslTrustStorePath.checkedPredicate(properties -> SSL.getValue((Properties)properties).orElse(false));

        public SslTrustStorePath() {
            super("SSLTrustStorePath", NOT_REQUIRED, IF_SSL_ENABLED, STRING_CONVERTER);
        }
    }

    private static class SslKeyStorePassword
    extends AbstractConnectionProperty<String> {
        private static final Predicate<Properties> IF_KEY_STORE = SslKeyStorePassword.checkedPredicate(properties -> SSL_KEY_STORE_PATH.getValue((Properties)properties).isPresent());

        public SslKeyStorePassword() {
            super("SSLKeyStorePassword", NOT_REQUIRED, IF_KEY_STORE, STRING_CONVERTER);
        }
    }

    private static class SslKeyStorePath
    extends AbstractConnectionProperty<String> {
        private static final Predicate<Properties> IF_SSL_ENABLED = SslKeyStorePath.checkedPredicate(properties -> SSL.getValue((Properties)properties).orElse(false));

        public SslKeyStorePath() {
            super("SSLKeyStorePath", NOT_REQUIRED, IF_SSL_ENABLED, STRING_CONVERTER);
        }
    }

    private static class Ssl
    extends AbstractConnectionProperty<Boolean> {
        public Ssl() {
            super("SSL", NOT_REQUIRED, ALLOWED, BOOLEAN_CONVERTER);
        }
    }

    private static class HttpProxy
    extends AbstractConnectionProperty<HostAndPort> {
        private static final Predicate<Properties> NO_SOCKS_PROXY = HttpProxy.checkedPredicate(properties -> !SOCKS_PROXY.getValue((Properties)properties).isPresent());

        public HttpProxy() {
            super("httpProxy", NOT_REQUIRED, NO_SOCKS_PROXY, HostAndPort::fromString);
        }
    }

    private static class SocksProxy
    extends AbstractConnectionProperty<HostAndPort> {
        private static final Predicate<Properties> NO_HTTP_PROXY = SocksProxy.checkedPredicate(properties -> !HTTP_PROXY.getValue((Properties)properties).isPresent());

        public SocksProxy() {
            super("socksProxy", NOT_REQUIRED, NO_HTTP_PROXY, HostAndPort::fromString);
        }
    }

    private static class Password
    extends AbstractConnectionProperty<String> {
        public Password() {
            super("password", NOT_REQUIRED, ALLOWED, STRING_CONVERTER);
        }
    }

    private static class User
    extends AbstractConnectionProperty<String> {
        public User() {
            super("user", REQUIRED, ALLOWED, NON_EMPTY_STRING_CONVERTER);
        }
    }
}

