/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SliceInput;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncodingFactory;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncodingSerde;
import com.facebook.presto.jdbc.internal.spi.block.MethodHandleUtil;
import com.facebook.presto.jdbc.internal.spi.block.SingleMapBlock;
import com.facebook.presto.jdbc.internal.spi.function.OperatorType;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import com.facebook.presto.jdbc.internal.spi.type.TypeManager;
import com.facebook.presto.jdbc.internal.spi.type.TypeSerde;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;

public class SingleMapBlockEncoding
implements BlockEncoding {
    public static final BlockEncodingFactory<SingleMapBlockEncoding> FACTORY = new SingleMapBlockEncodingFactory();
    private static final String NAME = "MAP_ELEMENT";
    private final Type keyType;
    private final MethodHandle keyNativeHashCode;
    private final MethodHandle keyBlockNativeEquals;
    private final BlockEncoding keyBlockEncoding;
    private final BlockEncoding valueBlockEncoding;

    public SingleMapBlockEncoding(Type keyType, MethodHandle keyNativeHashCode, MethodHandle keyBlockNativeEquals, BlockEncoding keyBlockEncoding, BlockEncoding valueBlockEncoding) {
        this.keyType = Objects.requireNonNull(keyType, "keyType is null");
        this.keyNativeHashCode = keyNativeHashCode;
        this.keyBlockNativeEquals = keyBlockNativeEquals;
        this.keyBlockEncoding = Objects.requireNonNull(keyBlockEncoding, "keyBlockEncoding is null");
        this.valueBlockEncoding = Objects.requireNonNull(valueBlockEncoding, "valueBlockEncoding is null");
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(SliceOutput sliceOutput, Block block) {
        SingleMapBlock singleMapBlock = (SingleMapBlock)block;
        int offset = singleMapBlock.getOffset();
        int positionCount = singleMapBlock.getPositionCount();
        this.keyBlockEncoding.writeBlock(sliceOutput, singleMapBlock.getKeyBlock().getRegion(offset / 2, positionCount / 2));
        this.valueBlockEncoding.writeBlock(sliceOutput, singleMapBlock.getValueBlock().getRegion(offset / 2, positionCount / 2));
        int[] hashTable = singleMapBlock.getHashTable();
        sliceOutput.appendInt(positionCount / 2 * 2);
        sliceOutput.writeBytes(Slices.wrappedIntArray(hashTable, offset / 2 * 2, positionCount / 2 * 2));
    }

    @Override
    public Block readBlock(SliceInput sliceInput) {
        Block keyBlock = this.keyBlockEncoding.readBlock(sliceInput);
        Block valueBlock = this.valueBlockEncoding.readBlock(sliceInput);
        int[] hashTable = new int[sliceInput.readInt()];
        sliceInput.readBytes(Slices.wrappedIntArray(hashTable));
        if (keyBlock.getPositionCount() != valueBlock.getPositionCount() || keyBlock.getPositionCount() * 2 != hashTable.length) {
            throw new IllegalArgumentException(String.format("Deserialized SingleMapBlock violates invariants: key %d, value %d, hash %d", keyBlock.getPositionCount(), valueBlock.getPositionCount(), hashTable.length));
        }
        return new SingleMapBlock(0, keyBlock.getPositionCount() * 2, keyBlock, valueBlock, hashTable, this.keyType, this.keyNativeHashCode, this.keyBlockNativeEquals);
    }

    @Override
    public BlockEncodingFactory getFactory() {
        return FACTORY;
    }

    public static class SingleMapBlockEncodingFactory
    implements BlockEncodingFactory<SingleMapBlockEncoding> {
        @Override
        public String getName() {
            return SingleMapBlockEncoding.NAME;
        }

        @Override
        public SingleMapBlockEncoding readEncoding(TypeManager typeManager, BlockEncodingSerde serde, SliceInput input) {
            Type keyType = TypeSerde.readType(typeManager, input);
            MethodHandle keyNativeHashCode = typeManager.resolveOperator(OperatorType.HASH_CODE, Collections.singletonList(keyType));
            MethodHandle keyNativeEquals = typeManager.resolveOperator(OperatorType.EQUAL, Arrays.asList(keyType, keyType));
            MethodHandle keyBlockNativeEquals = MethodHandleUtil.compose(keyNativeEquals, MethodHandleUtil.nativeValueGetter(keyType));
            BlockEncoding keyBlockEncoding = serde.readBlockEncoding(input);
            BlockEncoding valueBlockEncoding = serde.readBlockEncoding(input);
            return new SingleMapBlockEncoding(keyType, keyNativeHashCode, keyBlockNativeEquals, keyBlockEncoding, valueBlockEncoding);
        }

        @Override
        public void writeEncoding(BlockEncodingSerde serde, SliceOutput output, SingleMapBlockEncoding blockEncoding) {
            TypeSerde.writeType(output, blockEncoding.keyType);
            serde.writeBlockEncoding(output, blockEncoding.keyBlockEncoding);
            serde.writeBlockEncoding(output, blockEncoding.valueBlockEncoding);
        }
    }
}

