/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.eventlistener;

import com.facebook.presto.jdbc.internal.spi.eventlistener.StageCpuDistribution;
import com.facebook.presto.jdbc.internal.spi.eventlistener.StageGcStatistics;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class QueryStatistics {
    private final Duration cpuTime;
    private final Duration wallTime;
    private final Duration queuedTime;
    private final Optional<Duration> analysisTime;
    private final Optional<Duration> distributedPlanningTime;
    private final long peakUserMemoryBytes;
    private final long peakTotalNonRevocableMemoryBytes;
    private final long totalBytes;
    private final long totalRows;
    private final long outputBytes;
    private final long outputRows;
    private final long writtenBytes;
    private final long writtenRows;
    private final double cumulativeMemory;
    private final List<StageGcStatistics> stageGcStatistics;
    private final int completedSplits;
    private final boolean complete;
    private final List<StageCpuDistribution> cpuTimeDistribution;
    private final List<String> operatorSummaries;

    public QueryStatistics(Duration cpuTime, Duration wallTime, Duration queuedTime, Optional<Duration> analysisTime, Optional<Duration> distributedPlanningTime, long peakUserMemoryBytes, long peakTotalNonRevocableMemoryBytes, long totalBytes, long totalRows, long outputBytes, long outputRows, long writtenBytes, long writtenRows, double cumulativeMemory, List<StageGcStatistics> stageGcStatistics, int completedSplits, boolean complete, List<StageCpuDistribution> cpuTimeDistribution, List<String> operatorSummaries) {
        this.cpuTime = Objects.requireNonNull(cpuTime, "cpuTime is null");
        this.wallTime = Objects.requireNonNull(wallTime, "wallTime is null");
        this.queuedTime = Objects.requireNonNull(queuedTime, "queuedTime is null");
        this.analysisTime = Objects.requireNonNull(analysisTime, "analysisTime is null");
        this.distributedPlanningTime = Objects.requireNonNull(distributedPlanningTime, "distributedPlanningTime is null");
        this.peakUserMemoryBytes = peakUserMemoryBytes;
        this.peakTotalNonRevocableMemoryBytes = peakTotalNonRevocableMemoryBytes;
        this.totalBytes = totalBytes;
        this.totalRows = totalRows;
        this.outputBytes = outputBytes;
        this.outputRows = outputRows;
        this.writtenBytes = writtenBytes;
        this.writtenRows = writtenRows;
        this.cumulativeMemory = cumulativeMemory;
        this.stageGcStatistics = Objects.requireNonNull(stageGcStatistics, "stageGcStatistics is null");
        this.completedSplits = completedSplits;
        this.complete = complete;
        this.cpuTimeDistribution = Objects.requireNonNull(cpuTimeDistribution, "cpuTimeDistribution is null");
        this.operatorSummaries = Objects.requireNonNull(operatorSummaries, "operatorSummaries is null");
    }

    public Duration getCpuTime() {
        return this.cpuTime;
    }

    public Duration getWallTime() {
        return this.wallTime;
    }

    public Duration getQueuedTime() {
        return this.queuedTime;
    }

    public Optional<Duration> getAnalysisTime() {
        return this.analysisTime;
    }

    public Optional<Duration> getDistributedPlanningTime() {
        return this.distributedPlanningTime;
    }

    public long getPeakUserMemoryBytes() {
        return this.peakUserMemoryBytes;
    }

    public long getPeakTotalNonRevocableMemoryBytes() {
        return this.peakTotalNonRevocableMemoryBytes;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getTotalRows() {
        return this.totalRows;
    }

    public long getOutputBytes() {
        return this.outputBytes;
    }

    public long getOutputRows() {
        return this.outputRows;
    }

    public long getWrittenBytes() {
        return this.writtenBytes;
    }

    public long getWrittenRows() {
        return this.writtenRows;
    }

    public double getCumulativeMemory() {
        return this.cumulativeMemory;
    }

    public List<StageGcStatistics> getStageGcStatistics() {
        return this.stageGcStatistics;
    }

    public int getCompletedSplits() {
        return this.completedSplits;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public List<StageCpuDistribution> getCpuTimeDistribution() {
        return this.cpuTimeDistribution;
    }

    public List<String> getOperatorSummaries() {
        return this.operatorSummaries;
    }
}

