/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.client;

import com.facebook.presto.jdbc.internal.client.Column;
import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableList;
import com.facebook.presto.jdbc.internal.spi.type.NamedTypeSignature;
import com.facebook.presto.jdbc.internal.spi.type.ParameterKind;
import com.facebook.presto.jdbc.internal.spi.type.TypeSignature;
import com.facebook.presto.jdbc.internal.spi.type.TypeSignatureParameter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

final class FixJsonDataUtils {
    private FixJsonDataUtils() {
    }

    public static Iterable<List<Object>> fixData(List<Column> columns, Iterable<List<Object>> data) {
        if (data == null) {
            return null;
        }
        Objects.requireNonNull(columns, "columns is null");
        List signatures = columns.stream().map(column -> TypeSignature.parseTypeSignature(column.getType())).collect(Collectors.toList());
        ImmutableList.Builder rows = ImmutableList.builder();
        for (List<Object> row : data) {
            Preconditions.checkArgument(row.size() == columns.size(), "row/column size mismatch");
            ArrayList<Object> newRow = new ArrayList<Object>();
            for (int i = 0; i < row.size(); ++i) {
                newRow.add(FixJsonDataUtils.fixValue((TypeSignature)signatures.get(i), row.get(i)));
            }
            rows.add(Collections.unmodifiableList(newRow));
        }
        return rows.build();
    }

    private static Object fixValue(TypeSignature signature, Object value) {
        if (value == null) {
            return null;
        }
        if (signature.getBase().equals("array")) {
            ArrayList<Object> fixedValue = new ArrayList<Object>();
            for (Object object : (List)List.class.cast(value)) {
                fixedValue.add(FixJsonDataUtils.fixValue(signature.getTypeParametersAsTypeSignatures().get(0), object));
            }
            return fixedValue;
        }
        if (signature.getBase().equals("map")) {
            TypeSignature keySignature = signature.getTypeParametersAsTypeSignatures().get(0);
            TypeSignature valueSignature = signature.getTypeParametersAsTypeSignatures().get(1);
            HashMap<Object, Object> fixedValue = new HashMap<Object, Object>();
            for (Map.Entry entry : ((Map)Map.class.cast(value)).entrySet()) {
                fixedValue.put(FixJsonDataUtils.fixValue(keySignature, entry.getKey()), FixJsonDataUtils.fixValue(valueSignature, entry.getValue()));
            }
            return fixedValue;
        }
        if (signature.getBase().equals("row")) {
            LinkedHashMap<String, Object> fixedValue = new LinkedHashMap<String, Object>();
            List listValue = (List)List.class.cast(value);
            Preconditions.checkArgument(listValue.size() == signature.getParameters().size(), "Mismatched data values and row type");
            for (int i = 0; i < listValue.size(); ++i) {
                TypeSignatureParameter parameter = signature.getParameters().get(i);
                Preconditions.checkArgument(parameter.getKind() == ParameterKind.NAMED_TYPE, "Unexpected parameter [%s] for row type", (Object)parameter);
                NamedTypeSignature namedTypeSignature = parameter.getNamedTypeSignature();
                String key = namedTypeSignature.getName();
                fixedValue.put(key, FixJsonDataUtils.fixValue(namedTypeSignature.getTypeSignature(), listValue.get(i)));
            }
            return fixedValue;
        }
        switch (signature.getBase()) {
            case "bigint": {
                if (value instanceof String) {
                    return Long.parseLong((String)value);
                }
                return ((Number)value).longValue();
            }
            case "integer": {
                if (value instanceof String) {
                    return Integer.parseInt((String)value);
                }
                return ((Number)value).intValue();
            }
            case "smallint": {
                if (value instanceof String) {
                    return Short.parseShort((String)value);
                }
                return ((Number)value).shortValue();
            }
            case "tinyint": {
                if (value instanceof String) {
                    return Byte.parseByte((String)value);
                }
                return ((Number)value).byteValue();
            }
            case "double": {
                if (value instanceof String) {
                    return Double.parseDouble((String)value);
                }
                return ((Number)value).doubleValue();
            }
            case "real": {
                if (value instanceof String) {
                    return Float.valueOf(Float.parseFloat((String)value));
                }
                return Float.valueOf(((Number)value).floatValue());
            }
            case "boolean": {
                if (value instanceof String) {
                    return Boolean.parseBoolean((String)value);
                }
                return Boolean.class.cast(value);
            }
            case "varchar": 
            case "json": 
            case "time": 
            case "time with time zone": 
            case "timestamp": 
            case "timestamp with time zone": 
            case "date": 
            case "interval year to month": 
            case "interval day to second": 
            case "ipaddress": 
            case "decimal": 
            case "char": 
            case "Geometry": {
                return String.class.cast(value);
            }
            case "BingTile": {
                return value;
            }
        }
        if (value instanceof String) {
            return Base64.getDecoder().decode((String)value);
        }
        return value;
    }
}

