/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.block.AbstractMapBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.spi.block.BlockUtil;
import com.facebook.presto.jdbc.internal.spi.block.MapBlock;
import com.facebook.presto.jdbc.internal.spi.block.SingleMapBlockWriter;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;

public class MapBlockBuilder
extends AbstractMapBlock
implements BlockBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MapBlockBuilder.class).instanceSize();
    private final MethodHandle keyBlockHashCode;
    @Nullable
    private final BlockBuilderStatus blockBuilderStatus;
    private int positionCount;
    private int[] offsets;
    private boolean[] mapIsNull;
    private final BlockBuilder keyBlockBuilder;
    private final BlockBuilder valueBlockBuilder;
    private int[] hashTables;
    private boolean currentEntryOpened;

    public MapBlockBuilder(Type keyType, Type valueType, MethodHandle keyBlockNativeEquals, MethodHandle keyNativeHashCode, MethodHandle keyBlockHashCode, BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this(keyType, keyBlockNativeEquals, keyNativeHashCode, keyBlockHashCode, blockBuilderStatus, keyType.createBlockBuilder(blockBuilderStatus, expectedEntries), valueType.createBlockBuilder(blockBuilderStatus, expectedEntries), new int[expectedEntries + 1], new boolean[expectedEntries], MapBlockBuilder.newNegativeOneFilledArray(expectedEntries * 2));
    }

    private MapBlockBuilder(Type keyType, MethodHandle keyBlockNativeEquals, MethodHandle keyNativeHashCode, MethodHandle keyBlockHashCode, @Nullable BlockBuilderStatus blockBuilderStatus, BlockBuilder keyBlockBuilder, BlockBuilder valueBlockBuilder, int[] offsets, boolean[] mapIsNull, int[] hashTables) {
        super(keyType, keyNativeHashCode, keyBlockNativeEquals);
        Objects.requireNonNull(keyBlockHashCode, "keyBlockHashCode is null");
        this.keyBlockHashCode = keyBlockHashCode;
        this.blockBuilderStatus = blockBuilderStatus;
        this.positionCount = 0;
        this.offsets = Objects.requireNonNull(offsets, "offsets is null");
        this.mapIsNull = Objects.requireNonNull(mapIsNull, "mapIsNull is null");
        this.keyBlockBuilder = Objects.requireNonNull(keyBlockBuilder, "keyBlockBuilder is null");
        this.valueBlockBuilder = Objects.requireNonNull(valueBlockBuilder, "valueBlockBuilder is null");
        this.hashTables = Objects.requireNonNull(hashTables, "hashTables is null");
    }

    @Override
    protected Block getKeys() {
        return this.keyBlockBuilder;
    }

    @Override
    protected Block getValues() {
        return this.valueBlockBuilder;
    }

    @Override
    protected int[] getHashTables() {
        return this.hashTables;
    }

    @Override
    protected int[] getOffsets() {
        return this.offsets;
    }

    @Override
    protected int getOffsetBase() {
        return 0;
    }

    @Override
    protected boolean[] getMapIsNull() {
        return this.mapIsNull;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        return this.keyBlockBuilder.getSizeInBytes() + this.valueBlockBuilder.getSizeInBytes() + 5L * (long)this.positionCount + 8L * (long)this.keyBlockBuilder.getPositionCount();
    }

    @Override
    public long getRetainedSizeInBytes() {
        long size = (long)INSTANCE_SIZE + this.keyBlockBuilder.getRetainedSizeInBytes() + this.valueBlockBuilder.getRetainedSizeInBytes() + SizeOf.sizeOf(this.offsets) + SizeOf.sizeOf(this.mapIsNull) + SizeOf.sizeOf(this.hashTables);
        if (this.blockBuilderStatus != null) {
            size += (long)BlockBuilderStatus.INSTANCE_SIZE;
        }
        return size;
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.keyBlockBuilder, this.keyBlockBuilder.getRetainedSizeInBytes());
        consumer.accept(this.valueBlockBuilder, this.valueBlockBuilder.getRetainedSizeInBytes());
        consumer.accept(this.offsets, SizeOf.sizeOf(this.offsets));
        consumer.accept(this.mapIsNull, SizeOf.sizeOf(this.mapIsNull));
        consumer.accept(this.hashTables, SizeOf.sizeOf(this.hashTables));
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    public SingleMapBlockWriter beginBlockEntry() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Expected current entry to be closed but was opened");
        }
        this.currentEntryOpened = true;
        return new SingleMapBlockWriter(this.keyBlockBuilder.getPositionCount() * 2, this.keyBlockBuilder, this.valueBlockBuilder);
    }

    @Override
    public BlockBuilder closeEntry() {
        if (!this.currentEntryOpened) {
            throw new IllegalStateException("Expected entry to be opened but was closed");
        }
        this.entryAdded(false);
        this.currentEntryOpened = false;
        int previousAggregatedEntryCount = this.offsets[this.positionCount - 1];
        int aggregatedEntryCount = this.offsets[this.positionCount];
        int entryCount = aggregatedEntryCount - previousAggregatedEntryCount;
        if (this.hashTables.length < aggregatedEntryCount * 2) {
            int newSize = BlockUtil.calculateNewArraySize(aggregatedEntryCount * 2);
            int oldSize = this.hashTables.length;
            this.hashTables = Arrays.copyOf(this.hashTables, newSize);
            Arrays.fill(this.hashTables, oldSize, this.hashTables.length, -1);
        }
        MapBlockBuilder.buildHashTable(this.keyBlockBuilder, previousAggregatedEntryCount, entryCount, this.keyBlockHashCode, this.hashTables, previousAggregatedEntryCount * 2, entryCount * 2);
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(entryCount * 2 * 4);
        }
        return this;
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        this.entryAdded(true);
        return this;
    }

    private void entryAdded(boolean isNull) {
        if (this.keyBlockBuilder.getPositionCount() != this.valueBlockBuilder.getPositionCount()) {
            throw new IllegalStateException(String.format("keyBlock and valueBlock has different size: %s %s", this.keyBlockBuilder.getPositionCount(), this.valueBlockBuilder.getPositionCount()));
        }
        if (this.mapIsNull.length <= this.positionCount) {
            int newSize = BlockUtil.calculateNewArraySize(this.mapIsNull.length);
            this.mapIsNull = Arrays.copyOf(this.mapIsNull, newSize);
            this.offsets = Arrays.copyOf(this.offsets, newSize + 1);
        }
        this.offsets[this.positionCount + 1] = this.keyBlockBuilder.getPositionCount();
        this.mapIsNull[this.positionCount] = isNull;
        ++this.positionCount;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(5);
        }
    }

    @Override
    public Block build() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before the block can be built");
        }
        return MapBlock.createMapBlockInternal(0, this.positionCount, this.mapIsNull, this.offsets, this.keyBlockBuilder.build(), this.valueBlockBuilder.build(), Arrays.copyOf(this.hashTables, this.offsets[this.positionCount] * 2), this.keyType, this.keyBlockNativeEquals, this.keyNativeHashCode);
    }

    public String toString() {
        return "MapBlockBuilder{positionCount=" + this.getPositionCount() + '}';
    }

    @Override
    public BlockBuilder writeObject(Object value) {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Expected current entry to be closed but was opened");
        }
        this.currentEntryOpened = true;
        Block block = (Block)value;
        int blockPositionCount = block.getPositionCount();
        if (blockPositionCount % 2 != 0) {
            throw new IllegalArgumentException(String.format("block position count is not even: %s", blockPositionCount));
        }
        for (int i = 0; i < blockPositionCount; i += 2) {
            if (block.isNull(i)) {
                throw new IllegalArgumentException("Map keys must not be null");
            }
            block.writePositionTo(i, this.keyBlockBuilder);
            this.keyBlockBuilder.closeEntry();
            if (block.isNull(i + 1)) {
                this.valueBlockBuilder.appendNull();
                continue;
            }
            block.writePositionTo(i + 1, this.valueBlockBuilder);
            this.valueBlockBuilder.closeEntry();
        }
        return this;
    }

    @Override
    public BlockBuilder newBlockBuilderLike(BlockBuilderStatus blockBuilderStatus) {
        int newSize = BlockUtil.calculateBlockResetSize(this.getPositionCount());
        return new MapBlockBuilder(this.keyType, this.keyBlockNativeEquals, this.keyNativeHashCode, this.keyBlockHashCode, blockBuilderStatus, this.keyBlockBuilder.newBlockBuilderLike(blockBuilderStatus), this.valueBlockBuilder.newBlockBuilderLike(blockBuilderStatus), new int[newSize + 1], new boolean[newSize], MapBlockBuilder.newNegativeOneFilledArray(newSize * 2));
    }

    private static int[] newNegativeOneFilledArray(int size) {
        int[] hashTable = new int[size];
        Arrays.fill(hashTable, -1);
        return hashTable;
    }

    static void buildHashTable(Block keyBlock, int keyOffset, int keyCount, MethodHandle keyBlockHashCode, int[] outputHashTable, int hashTableOffset, int hashTableSize) {
        int i = 0;
        while (i < keyCount) {
            long hashCode;
            if (keyBlock.isNull(keyOffset + i)) {
                throw new IllegalArgumentException("map keys cannot be null");
            }
            try {
                hashCode = keyBlockHashCode.invokeExact(keyBlock, keyOffset + i);
            }
            catch (Throwable throwable) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new RuntimeException(throwable);
            }
            int hash = (int)Math.floorMod(hashCode, (long)hashTableSize);
            while (true) {
                if (outputHashTable[hashTableOffset + hash] == -1) break;
                if (++hash != hashTableSize) continue;
                hash = 0;
            }
            outputHashTable[hashTableOffset + hash] = i++;
        }
    }
}

