/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.block.AbstractRowBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import java.util.Objects;
import java.util.function.BiConsumer;

public class RowBlock
extends AbstractRowBlock {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(RowBlock.class).instanceSize();
    private final int startOffset;
    private final int positionCount;
    private final boolean[] rowIsNull;
    private final int[] fieldBlockOffsets;
    private final Block[] fieldBlocks;
    private volatile long sizeInBytes;
    private final long retainedSizeInBytes;

    public static Block fromFieldBlocks(int positionCount, boolean[] rowIsNull, int[] fieldBlockOffsets, Block[] fieldBlocks) {
        RowBlock.validateConstructorArguments(0, positionCount, rowIsNull, fieldBlockOffsets, fieldBlocks);
        for (int position = 0; position < positionCount; ++position) {
            if (!rowIsNull[position] || fieldBlockOffsets[position + 1] - fieldBlockOffsets[position] == 0) continue;
            throw new IllegalArgumentException("A null row must have zero entries");
        }
        return new RowBlock(0, positionCount, rowIsNull, fieldBlockOffsets, fieldBlocks);
    }

    static RowBlock createRowBlockInternal(int startOffset, int positionCount, boolean[] rowIsNull, int[] fieldBlockOffsets, Block[] fieldBlocks) {
        RowBlock.validateConstructorArguments(startOffset, positionCount, rowIsNull, fieldBlockOffsets, fieldBlocks);
        return new RowBlock(startOffset, positionCount, rowIsNull, fieldBlockOffsets, fieldBlocks);
    }

    private static void validateConstructorArguments(int startOffset, int positionCount, boolean[] rowIsNull, int[] fieldBlockOffsets, Block[] fieldBlocks) {
        if (startOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        Objects.requireNonNull(rowIsNull, "rowIsNull is null");
        if (rowIsNull.length - startOffset < positionCount) {
            throw new IllegalArgumentException("rowIsNull length is less than positionCount");
        }
        Objects.requireNonNull(fieldBlockOffsets, "fieldBlockOffsets is null");
        if (fieldBlockOffsets.length - startOffset < positionCount + 1) {
            throw new IllegalArgumentException("fieldBlockOffsets length is less than positionCount");
        }
        Objects.requireNonNull(fieldBlocks, "fieldBlocks is null");
        if (fieldBlocks.length <= 0) {
            throw new IllegalArgumentException("Number of fields in RowBlock must be positive");
        }
        int firstFieldBlockPositionCount = fieldBlocks[0].getPositionCount();
        for (int i = 1; i < fieldBlocks.length; ++i) {
            if (firstFieldBlockPositionCount == fieldBlocks[i].getPositionCount()) continue;
            throw new IllegalArgumentException(String.format("length of field blocks differ: field 0: %s, block %s: %s", firstFieldBlockPositionCount, i, fieldBlocks[i].getPositionCount()));
        }
    }

    private RowBlock(int startOffset, int positionCount, boolean[] rowIsNull, int[] fieldBlockOffsets, Block[] fieldBlocks) {
        super(fieldBlocks.length);
        this.startOffset = startOffset;
        this.positionCount = positionCount;
        this.rowIsNull = rowIsNull;
        this.fieldBlockOffsets = fieldBlockOffsets;
        this.fieldBlocks = fieldBlocks;
        this.sizeInBytes = -1L;
        long retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf(fieldBlockOffsets) + SizeOf.sizeOf(rowIsNull);
        for (Block fieldBlock : fieldBlocks) {
            retainedSizeInBytes += fieldBlock.getRetainedSizeInBytes();
        }
        this.retainedSizeInBytes = retainedSizeInBytes;
    }

    @Override
    protected Block[] getFieldBlocks() {
        return this.fieldBlocks;
    }

    @Override
    protected int[] getFieldBlockOffsets() {
        return this.fieldBlockOffsets;
    }

    @Override
    protected int getOffsetBase() {
        return this.startOffset;
    }

    @Override
    protected boolean[] getRowIsNull() {
        return this.rowIsNull;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        if (this.sizeInBytes < 0L) {
            this.calculateSize();
        }
        return this.sizeInBytes;
    }

    private void calculateSize() {
        int startFieldBlockOffset = this.fieldBlockOffsets[this.startOffset];
        int endFieldBlockOffset = this.fieldBlockOffsets[this.startOffset + this.positionCount];
        int fieldBlockLength = endFieldBlockOffset - startFieldBlockOffset;
        long sizeInBytes = 5L * (long)this.positionCount;
        for (int i = 0; i < this.numFields; ++i) {
            sizeInBytes += this.fieldBlocks[i].getRegionSizeInBytes(startFieldBlockOffset, fieldBlockLength);
        }
        this.sizeInBytes = sizeInBytes;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        for (int i = 0; i < this.numFields; ++i) {
            consumer.accept(this.fieldBlocks[i], this.fieldBlocks[i].getRetainedSizeInBytes());
        }
        consumer.accept(this.fieldBlockOffsets, SizeOf.sizeOf(this.fieldBlockOffsets));
        consumer.accept(this.rowIsNull, SizeOf.sizeOf(this.rowIsNull));
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    public String toString() {
        return String.format("RowBlock{numFields=%d, positionCount=%d}", this.numFields, this.getPositionCount());
    }
}

