/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.block.AbstractSingleRowBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.SingleRowBlockEncoding;
import java.util.function.BiConsumer;

public class SingleRowBlock
extends AbstractSingleRowBlock {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleRowBlock.class).instanceSize();
    private final Block[] fieldBlocks;

    SingleRowBlock(int rowIndex, Block[] fieldBlocks) {
        super(rowIndex);
        this.fieldBlocks = fieldBlocks;
    }

    @Override
    protected Block getFieldBlock(int fieldIndex) {
        return this.fieldBlocks[fieldIndex];
    }

    @Override
    public int getPositionCount() {
        return this.fieldBlocks.length;
    }

    @Override
    public long getSizeInBytes() {
        long sizeInBytes = 0L;
        for (int i = 0; i < this.fieldBlocks.length; ++i) {
            sizeInBytes += this.getFieldBlock(i).getSizeInBytes();
        }
        return sizeInBytes;
    }

    @Override
    public long getRetainedSizeInBytes() {
        long retainedSizeInBytes = INSTANCE_SIZE;
        for (int i = 0; i < this.fieldBlocks.length; ++i) {
            retainedSizeInBytes += this.getFieldBlock(i).getRetainedSizeInBytes();
        }
        return retainedSizeInBytes;
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        for (int i = 0; i < this.fieldBlocks.length; ++i) {
            consumer.accept(this.fieldBlocks[i], this.fieldBlocks[i].getRetainedSizeInBytes());
        }
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    public BlockEncoding getEncoding() {
        BlockEncoding[] fieldBlockEncodings = new BlockEncoding[this.fieldBlocks.length];
        for (int i = 0; i < this.fieldBlocks.length; ++i) {
            fieldBlockEncodings[i] = this.fieldBlocks[i].getEncoding();
        }
        return new SingleRowBlockEncoding(fieldBlockEncodings);
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public String toString() {
        return String.format("SingleRowBlock{numFields=%d}", this.fieldBlocks.length);
    }
}

