/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.resourceGroups;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class SelectionCriteria {
    private final boolean authenticated;
    private final String user;
    private final Optional<String> source;
    private final Set<String> clientTags;
    private final int queryPriority;
    private final Optional<String> queryType;

    public SelectionCriteria(boolean authenticated, String user, Optional<String> source, Set<String> clientTags, int queryPriority, Optional<String> queryType) {
        this.authenticated = authenticated;
        this.user = Objects.requireNonNull(user, "user is null");
        this.source = Objects.requireNonNull(source, "source is null");
        this.clientTags = Collections.unmodifiableSet(Objects.requireNonNull(clientTags, "tags is null"));
        this.queryPriority = queryPriority;
        this.queryType = Objects.requireNonNull(queryType, "queryType is null");
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public String getUser() {
        return this.user;
    }

    public Optional<String> getSource() {
        return this.source;
    }

    public Set<String> getTags() {
        return this.clientTags;
    }

    public int getQueryPriority() {
        return this.queryPriority;
    }

    public Optional<String> getQueryType() {
        return this.queryType;
    }
}

