/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.LazyBlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.LazyBlockLoader;
import java.util.Objects;
import java.util.function.BiConsumer;

public class LazyBlock
implements Block {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LazyBlock.class).instanceSize();
    private final int positionCount;
    private LazyBlockLoader<LazyBlock> loader;
    private Block block;

    public LazyBlock(int positionCount, LazyBlockLoader<LazyBlock> loader) {
        this.positionCount = positionCount;
        this.loader = Objects.requireNonNull(loader, "loader is null");
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getSliceLength(int position) {
        this.assureLoaded();
        return this.block.getSliceLength(position);
    }

    @Override
    public byte getByte(int position, int offset) {
        this.assureLoaded();
        return this.block.getByte(position, offset);
    }

    @Override
    public short getShort(int position, int offset) {
        this.assureLoaded();
        return this.block.getShort(position, offset);
    }

    @Override
    public int getInt(int position, int offset) {
        this.assureLoaded();
        return this.block.getInt(position, offset);
    }

    @Override
    public long getLong(int position, int offset) {
        this.assureLoaded();
        return this.block.getLong(position, offset);
    }

    @Override
    public Slice getSlice(int position, int offset, int length) {
        this.assureLoaded();
        return this.block.getSlice(position, offset, length);
    }

    @Override
    public <T> T getObject(int position, Class<T> clazz) {
        this.assureLoaded();
        return this.block.getObject(position, clazz);
    }

    @Override
    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        this.assureLoaded();
        return this.block.bytesEqual(position, offset, otherSlice, otherOffset, length);
    }

    @Override
    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        this.assureLoaded();
        return this.block.bytesCompare(position, offset, length, otherSlice, otherOffset, otherLength);
    }

    @Override
    public void writeBytesTo(int position, int offset, int length, BlockBuilder blockBuilder) {
        this.assureLoaded();
        this.block.writeBytesTo(position, offset, length, blockBuilder);
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.assureLoaded();
        this.block.writePositionTo(position, blockBuilder);
    }

    @Override
    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        this.assureLoaded();
        return this.block.equals(position, offset, otherBlock, otherPosition, otherOffset, length);
    }

    @Override
    public long hash(int position, int offset, int length) {
        this.assureLoaded();
        return this.block.hash(position, offset, length);
    }

    @Override
    public int compareTo(int leftPosition, int leftOffset, int leftLength, Block rightBlock, int rightPosition, int rightOffset, int rightLength) {
        this.assureLoaded();
        return this.block.compareTo(leftPosition, leftOffset, leftLength, rightBlock, rightPosition, rightOffset, rightLength);
    }

    @Override
    public Block getSingleValueBlock(int position) {
        this.assureLoaded();
        return this.block.getSingleValueBlock(position);
    }

    @Override
    public long getSizeInBytes() {
        this.assureLoaded();
        return this.block.getSizeInBytes();
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        this.assureLoaded();
        return this.block.getRegionSizeInBytes(position, length);
    }

    @Override
    public long getRetainedSizeInBytes() {
        this.assureLoaded();
        return (long)INSTANCE_SIZE + this.block.getRetainedSizeInBytes();
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        this.assureLoaded();
        this.block.retainedBytesForEachPart(consumer);
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    public BlockEncoding getEncoding() {
        this.assureLoaded();
        return new LazyBlockEncoding(this.block.getEncoding());
    }

    @Override
    public Block getPositions(int[] positions, int offset, int length) {
        this.assureLoaded();
        return this.block.getPositions(positions, offset, length);
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        this.assureLoaded();
        return this.block.copyPositions(positions, offset, length);
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        this.assureLoaded();
        return this.block.getRegion(positionOffset, length);
    }

    @Override
    public Block copyRegion(int position, int length) {
        this.assureLoaded();
        return this.block.copyRegion(position, length);
    }

    @Override
    public boolean isNull(int position) {
        this.assureLoaded();
        return this.block.isNull(position);
    }

    public Block getBlock() {
        this.assureLoaded();
        return this.block;
    }

    public void setBlock(Block block) {
        if (this.block != null) {
            throw new IllegalStateException("block already set");
        }
        this.block = Objects.requireNonNull(block, "block is null");
    }

    public boolean isLoaded() {
        return this.block != null;
    }

    @Override
    public void assureLoaded() {
        if (this.block != null) {
            return;
        }
        this.loader.load(this);
        if (this.block == null) {
            throw new IllegalArgumentException("Lazy block loader did not load this block");
        }
        this.loader = null;
    }
}

