/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.block.PageBuilderStatus;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Objects;

public class BlockBuilderStatus {
    public static final int INSTANCE_SIZE = BlockBuilderStatus.deepInstanceSize(BlockBuilderStatus.class);
    public static final int DEFAULT_MAX_BLOCK_SIZE_IN_BYTES = 65536;
    private final PageBuilderStatus pageBuilderStatus;
    private final int maxBlockSizeInBytes;
    private int currentSize;

    BlockBuilderStatus(PageBuilderStatus pageBuilderStatus, int maxBlockSizeInBytes) {
        this.pageBuilderStatus = Objects.requireNonNull(pageBuilderStatus, "pageBuilderStatus must not be null");
        this.maxBlockSizeInBytes = maxBlockSizeInBytes;
    }

    public int getMaxBlockSizeInBytes() {
        return this.maxBlockSizeInBytes;
    }

    public void addBytes(int bytes) {
        this.currentSize += bytes;
        this.pageBuilderStatus.addBytes(bytes);
        if (this.currentSize >= this.maxBlockSizeInBytes) {
            this.pageBuilderStatus.setFull();
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("BlockBuilderStatus{");
        buffer.append("maxSizeInBytes=").append(this.maxBlockSizeInBytes);
        buffer.append(", currentSize=").append(this.currentSize);
        buffer.append('}');
        return buffer.toString();
    }

    private static int deepInstanceSize(Class<?> clazz) {
        if (clazz.isArray()) {
            throw new IllegalArgumentException(String.format("Cannot determine size of %s because it contains an array", clazz.getSimpleName()));
        }
        if (clazz.isInterface()) {
            throw new IllegalArgumentException(String.format("%s is an interface", clazz.getSimpleName()));
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            throw new IllegalArgumentException(String.format("%s is abstract", clazz.getSimpleName()));
        }
        if (!clazz.getSuperclass().equals(Object.class)) {
            throw new IllegalArgumentException(String.format("Cannot determine size of a subclass. %s extends from %s", clazz.getSimpleName(), clazz.getSuperclass().getSimpleName()));
        }
        int size = ClassLayout.parseClass(clazz).instanceSize();
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getType().isPrimitive()) continue;
            size += BlockBuilderStatus.deepInstanceSize(field.getType());
        }
        return size;
    }
}

