/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.ErrorCodeSupplier;
import com.facebook.presto.jdbc.internal.spi.PrestoException;
import com.facebook.presto.jdbc.internal.spi.StandardErrorCode;
import com.facebook.presto.jdbc.internal.spi.block.AbstractSingleMapBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.util.function.BiConsumer;

public class SingleMapBlock
extends AbstractSingleMapBlock {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleMapBlock.class).instanceSize();
    private final int offset;
    private final int positionCount;
    private final Block keyBlock;
    private final Block valueBlock;
    private final int[] hashTable;
    final Type keyType;
    private final MethodHandle keyNativeHashCode;
    private final MethodHandle keyBlockNativeEquals;

    SingleMapBlock(int offset, int positionCount, Block keyBlock, Block valueBlock, int[] hashTable, Type keyType, MethodHandle keyNativeHashCode, MethodHandle keyBlockNativeEquals) {
        this.offset = offset;
        this.positionCount = positionCount;
        this.keyBlock = keyBlock;
        this.valueBlock = valueBlock;
        this.hashTable = hashTable;
        this.keyType = keyType;
        this.keyNativeHashCode = keyNativeHashCode;
        this.keyBlockNativeEquals = keyBlockNativeEquals;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        return this.keyBlock.getRegionSizeInBytes(this.offset / 2, this.positionCount / 2) + this.valueBlock.getRegionSizeInBytes(this.offset / 2, this.positionCount / 2) + SizeOf.sizeOfIntArray(this.positionCount / 2 * 2);
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.keyBlock.getRetainedSizeInBytes() + this.valueBlock.getRetainedSizeInBytes() + SizeOf.sizeOf(this.hashTable);
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.keyBlock, this.keyBlock.getRetainedSizeInBytes());
        consumer.accept(this.valueBlock, this.valueBlock.getRetainedSizeInBytes());
        consumer.accept(this.hashTable, SizeOf.sizeOf(this.hashTable));
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    public String getEncodingName() {
        return "MAP_ELEMENT";
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    Block getRawKeyBlock() {
        return this.keyBlock;
    }

    @Override
    Block getRawValueBlock() {
        return this.valueBlock;
    }

    public String toString() {
        return String.format("SingleMapBlock{positionCount=%d}", this.getPositionCount());
    }

    int[] getHashTable() {
        return this.hashTable;
    }

    public int seekKey(Object nativeValue) {
        long hashCode;
        if (this.positionCount == 0) {
            return -1;
        }
        try {
            hashCode = this.keyNativeHashCode.invoke(nativeValue);
        }
        catch (Throwable throwable) {
            throw SingleMapBlock.handleThrowable(throwable);
        }
        int hashTableOffset = this.offset / 2 * 2;
        int hashTableSize = this.positionCount / 2 * 2;
        int hash = (int)Math.floorMod(hashCode, (long)hashTableSize);
        int keyPosition;
        while ((keyPosition = this.hashTable[hashTableOffset + hash]) != -1) {
            boolean match;
            try {
                match = this.keyBlockNativeEquals.invoke(this.keyBlock, this.offset / 2 + keyPosition, nativeValue);
            }
            catch (Throwable throwable) {
                throw SingleMapBlock.handleThrowable(throwable);
            }
            if (match) {
                return keyPosition * 2 + 1;
            }
            if (++hash != hashTableSize) continue;
            hash = 0;
        }
        return -1;
    }

    public int seekKeyExact(long nativeValue) {
        long hashCode;
        if (this.positionCount == 0) {
            return -1;
        }
        try {
            hashCode = this.keyNativeHashCode.invokeExact(nativeValue);
        }
        catch (Throwable throwable) {
            throw SingleMapBlock.handleThrowable(throwable);
        }
        int hashTableOffset = this.offset / 2 * 2;
        int hashTableSize = this.positionCount / 2 * 2;
        int hash = (int)Math.floorMod(hashCode, (long)hashTableSize);
        int keyPosition;
        while ((keyPosition = this.hashTable[hashTableOffset + hash]) != -1) {
            boolean match;
            try {
                match = this.keyBlockNativeEquals.invokeExact(this.keyBlock, this.offset / 2 + keyPosition, nativeValue);
            }
            catch (Throwable throwable) {
                throw SingleMapBlock.handleThrowable(throwable);
            }
            if (match) {
                return keyPosition * 2 + 1;
            }
            if (++hash != hashTableSize) continue;
            hash = 0;
        }
        return -1;
    }

    public int seekKeyExact(boolean nativeValue) {
        long hashCode;
        if (this.positionCount == 0) {
            return -1;
        }
        try {
            hashCode = this.keyNativeHashCode.invokeExact(nativeValue);
        }
        catch (Throwable throwable) {
            throw SingleMapBlock.handleThrowable(throwable);
        }
        int hashTableOffset = this.offset / 2 * 2;
        int hashTableSize = this.positionCount / 2 * 2;
        int hash = (int)Math.floorMod(hashCode, (long)hashTableSize);
        int keyPosition;
        while ((keyPosition = this.hashTable[hashTableOffset + hash]) != -1) {
            boolean match;
            try {
                match = this.keyBlockNativeEquals.invokeExact(this.keyBlock, this.offset / 2 + keyPosition, nativeValue);
            }
            catch (Throwable throwable) {
                throw SingleMapBlock.handleThrowable(throwable);
            }
            if (match) {
                return keyPosition * 2 + 1;
            }
            if (++hash != hashTableSize) continue;
            hash = 0;
        }
        return -1;
    }

    public int seekKeyExact(double nativeValue) {
        long hashCode;
        if (this.positionCount == 0) {
            return -1;
        }
        try {
            hashCode = this.keyNativeHashCode.invokeExact(nativeValue);
        }
        catch (Throwable throwable) {
            throw SingleMapBlock.handleThrowable(throwable);
        }
        int hashTableOffset = this.offset / 2 * 2;
        int hashTableSize = this.positionCount / 2 * 2;
        int hash = (int)Math.floorMod(hashCode, (long)hashTableSize);
        int keyPosition;
        while ((keyPosition = this.hashTable[hashTableOffset + hash]) != -1) {
            boolean match;
            try {
                match = this.keyBlockNativeEquals.invokeExact(this.keyBlock, this.offset / 2 + keyPosition, nativeValue);
            }
            catch (Throwable throwable) {
                throw SingleMapBlock.handleThrowable(throwable);
            }
            if (match) {
                return keyPosition * 2 + 1;
            }
            if (++hash != hashTableSize) continue;
            hash = 0;
        }
        return -1;
    }

    public int seekKeyExact(Slice nativeValue) {
        long hashCode;
        if (this.positionCount == 0) {
            return -1;
        }
        try {
            hashCode = this.keyNativeHashCode.invokeExact(nativeValue);
        }
        catch (Throwable throwable) {
            throw SingleMapBlock.handleThrowable(throwable);
        }
        int hashTableOffset = this.offset / 2 * 2;
        int hashTableSize = this.positionCount / 2 * 2;
        int hash = (int)Math.floorMod(hashCode, (long)hashTableSize);
        int keyPosition;
        while ((keyPosition = this.hashTable[hashTableOffset + hash]) != -1) {
            boolean match;
            try {
                match = this.keyBlockNativeEquals.invokeExact(this.keyBlock, this.offset / 2 + keyPosition, nativeValue);
            }
            catch (Throwable throwable) {
                throw SingleMapBlock.handleThrowable(throwable);
            }
            if (match) {
                return keyPosition * 2 + 1;
            }
            if (++hash != hashTableSize) continue;
            hash = 0;
        }
        return -1;
    }

    public int seekKeyExact(Block nativeValue) {
        long hashCode;
        if (this.positionCount == 0) {
            return -1;
        }
        try {
            hashCode = this.keyNativeHashCode.invokeExact(nativeValue);
        }
        catch (Throwable throwable) {
            throw SingleMapBlock.handleThrowable(throwable);
        }
        int hashTableOffset = this.offset / 2 * 2;
        int hashTableSize = this.positionCount / 2 * 2;
        int hash = (int)Math.floorMod(hashCode, (long)hashTableSize);
        int keyPosition;
        while ((keyPosition = this.hashTable[hashTableOffset + hash]) != -1) {
            boolean match;
            try {
                match = this.keyBlockNativeEquals.invokeExact(this.keyBlock, this.offset / 2 + keyPosition, nativeValue);
            }
            catch (Throwable throwable) {
                throw SingleMapBlock.handleThrowable(throwable);
            }
            if (match) {
                return keyPosition * 2 + 1;
            }
            if (++hash != hashTableSize) continue;
            hash = 0;
        }
        return -1;
    }

    private static RuntimeException handleThrowable(Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof PrestoException) {
            throw (PrestoException)throwable;
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, throwable);
    }
}

