/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.block.AbstractArrayBlock;
import com.facebook.presto.jdbc.internal.spi.block.ArrayBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.spi.block.BlockUtil;
import com.facebook.presto.jdbc.internal.spi.block.SingleArrayBlockWriter;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;

public class ArrayBlockBuilder
extends AbstractArrayBlock
implements BlockBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ArrayBlockBuilder.class).instanceSize();
    private int positionCount;
    @Nullable
    private BlockBuilderStatus blockBuilderStatus;
    private boolean initialized;
    private int initialEntryCount;
    private int[] offsets = new int[1];
    private boolean[] valueIsNull = new boolean[0];
    private final BlockBuilder values;
    private boolean currentEntryOpened;
    private long retainedSizeInBytes;

    public ArrayBlockBuilder(BlockBuilder valuesBlock, BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this(blockBuilderStatus, valuesBlock, expectedEntries);
    }

    public ArrayBlockBuilder(Type elementType, BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        this(blockBuilderStatus, elementType.createBlockBuilder(blockBuilderStatus, expectedEntries, expectedBytesPerEntry), expectedEntries);
    }

    public ArrayBlockBuilder(Type elementType, BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this(blockBuilderStatus, elementType.createBlockBuilder(blockBuilderStatus, expectedEntries), expectedEntries);
    }

    private ArrayBlockBuilder(@Nullable BlockBuilderStatus blockBuilderStatus, BlockBuilder values, int expectedEntries) {
        this.blockBuilderStatus = blockBuilderStatus;
        this.values = Objects.requireNonNull(values, "values is null");
        this.initialEntryCount = Math.max(expectedEntries, 1);
        this.updateDataSize();
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        return this.values.getSizeInBytes() + 5L * (long)this.positionCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes + this.values.getRetainedSizeInBytes();
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.values, this.values.getRetainedSizeInBytes());
        consumer.accept(this.offsets, SizeOf.sizeOf(this.offsets));
        consumer.accept(this.valueIsNull, SizeOf.sizeOf(this.valueIsNull));
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    protected Block getRawElementBlock() {
        return this.values;
    }

    @Override
    protected int[] getOffsets() {
        return this.offsets;
    }

    @Override
    protected int getOffsetBase() {
        return 0;
    }

    @Override
    protected boolean[] getValueIsNull() {
        return this.valueIsNull;
    }

    @Override
    public BlockBuilder appendStructure(Block block) {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Expected current entry to be closed but was opened");
        }
        this.currentEntryOpened = true;
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) {
                this.values.appendNull();
                continue;
            }
            block.writePositionTo(i, this.values);
        }
        this.closeEntry();
        return this;
    }

    @Override
    public BlockBuilder appendStructureInternal(Block block, int position) {
        if (!(block instanceof AbstractArrayBlock)) {
            throw new IllegalArgumentException();
        }
        AbstractArrayBlock arrayBlock = (AbstractArrayBlock)block;
        SingleArrayBlockWriter entryBuilder = this.beginBlockEntry();
        int startValueOffset = arrayBlock.getOffset(position);
        int endValueOffset = arrayBlock.getOffset(position + 1);
        for (int i = startValueOffset; i < endValueOffset; ++i) {
            if (arrayBlock.getRawElementBlock().isNull(i)) {
                entryBuilder.appendNull();
                continue;
            }
            arrayBlock.getRawElementBlock().writePositionTo(i, entryBuilder);
        }
        this.closeEntry();
        return this;
    }

    @Override
    public SingleArrayBlockWriter beginBlockEntry() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Expected current entry to be closed but was closed");
        }
        this.currentEntryOpened = true;
        return new SingleArrayBlockWriter(this.values, this.values.getPositionCount());
    }

    @Override
    public BlockBuilder closeEntry() {
        if (!this.currentEntryOpened) {
            throw new IllegalStateException("Expected entry to be opened but was closed");
        }
        this.entryAdded(false);
        this.currentEntryOpened = false;
        return this;
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        this.entryAdded(true);
        return this;
    }

    private void entryAdded(boolean isNull) {
        if (this.valueIsNull.length <= this.positionCount) {
            this.growCapacity();
        }
        this.offsets[this.positionCount + 1] = this.values.getPositionCount();
        this.valueIsNull[this.positionCount] = isNull;
        ++this.positionCount;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(5);
        }
    }

    private void growCapacity() {
        int newSize;
        if (this.initialized) {
            newSize = BlockUtil.calculateNewArraySize(this.valueIsNull.length);
        } else {
            newSize = this.initialEntryCount;
            this.initialized = true;
        }
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.offsets = Arrays.copyOf(this.offsets, newSize + 1);
        this.updateDataSize();
    }

    private void updateDataSize() {
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf(this.valueIsNull) + SizeOf.sizeOf(this.offsets);
        if (this.blockBuilderStatus != null) {
            this.retainedSizeInBytes += (long)BlockBuilderStatus.INSTANCE_SIZE;
        }
    }

    @Override
    public ArrayBlock build() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before the block can be built");
        }
        return ArrayBlock.createArrayBlockInternal(0, this.positionCount, this.valueIsNull, this.offsets, this.values.build());
    }

    @Override
    public BlockBuilder newBlockBuilderLike(BlockBuilderStatus blockBuilderStatus) {
        int newSize = BlockUtil.calculateBlockResetSize(this.getPositionCount());
        return new ArrayBlockBuilder(blockBuilderStatus, this.values.newBlockBuilderLike(blockBuilderStatus), newSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ArrayBlockBuilder{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }
}

